<?php
    while( $blogpost->have_posts() ):
    $blogpost->the_post();
    $title = ( $settings['title_count'] ) ? wp_trim_words( get_the_title(), $settings['title_count'], '' ) : get_the_title();
?>
<div class="col-xl-4">
    <div class="vs-blog blog-style1">
        <div class="blog-img">
            <?php if( has_post_thumbnail() ): ?>
                <?php the_post_thumbnail( 'home-slider-blog-image', array( 'class' => 'w-100' ) ); ?>
            <?php endif; ?>
            <div class="meta-box">
                <a href="<?php echo esc_url( playrex_blog_date_permalink() ); ?>">
                    <?php echo esc_html( get_the_date() ); ?>
                </a>
                <a href="<?php echo get_author_posts_url( get_the_author_meta('ID')) ?>"><?php _e('By', 'playrex') ?>
                    <?php echo esc_html( ucwords( get_the_author()) ); ?>
                </a>
            </div>
        </div>
        <div class="blog-content">
        <h3 class="blog-title h5">
                <a href="<?php the_permalink(); ?>">
                    <?php echo $title; ?>
                </a>
            </h3>
            <a href="<?php the_permalink(); ?>" class="blog-btn">
                <?php echo esc_html( $settings['read_more_text'] ); ?>
                <i class="far fa-angle-right"></i>
            </a>
        </div>
    </div>
</div>
<?php
    endwhile;
    wp_reset_postdata();
?>