<?php while($blogpost->have_posts()): $blogpost->the_post();
    $title      = ( $settings['title_count'] ) ? wp_trim_words( get_the_title(), $settings['title_count'], '' ) : get_the_title();
    $excerpt    = ( $settings['title_count'] ) ? wp_trim_words( get_the_excerpt(), $settings['excerpt_count'], '' ) : get_the_excerpt();
?>
<div class="col-xl-4">
    <div class="vs-blog blog-style2">
        <?php if( has_post_thumbnail() ): ?>
            <div class="blog-img">
                <?php the_post_thumbnail( 'home-slider-blog-image-two', array( 'class' => 'w-100' ) ); ?>
            </div>
        <?php endif; ?>
        <div class="blog-content">
            <?php
                $categories = get_the_category();

                if( ! empty( $categories ) ){
                    echo '<div class="blog-category">';
                        echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'">'.esc_html( $categories[0]->name ).'</a>';
                    echo '</div>';
                }
            ?>
            <h3 class="blog-title h5">
                <a href="<?php the_permalink(); ?>">
                    <?php echo $title; ?>
                </a>
            </h3>
            <p class="blog-text">
                <?php echo esc_html( $excerpt ); ?>
            </p>
            <div class="blog-meta">
                <a href="<?php echo esc_url( playrex_blog_date_permalink() ); ?>">
                    <i class="far fa-clock"></i>
                    <?php echo esc_html( get_the_date() ); ?>
                </a>
                <?php
                    echo '<a href="'.esc_url( get_comments_link( get_the_ID() ) ).'"><i class="far fa-comment-alt"></i>'.esc_html( get_comments_number() ).'</a>';
                ?>
            </div>
        </div>
    </div>
</div>
<?php
    endwhile;
    wp_reset_postdata();
?>