<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Feature Icon Box Widget .
 *
 */
class Playrex_Feature_Icon_Box extends Widget_Base {

	public function get_name() {
		return 'playrexs_featureiconbox';
	}

	public function get_title() {
		return __( 'Feature Feature Icon Box', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-frame-minimize playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'icon box', 'box', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_feature_icon_box',
			[
				'label'		 	=> __( 'Feature Icon Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        /*  --------------- Content Section ---------------*/

		
        $this->add_control(
			'feature_icon',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);


        $this->add_control(
			'iconbox_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Games are Innovation ', 'playrex' ),
				'dynamic' 		=> ['active' => true ],
			]
        );
        $this->add_control(
			'iconbox_contnet',
			[
				'label' 	=> __( 'Discription', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Loec qu felis, ultricies nec, pellen sem. Nulla consequat massa quic consequat ma gilla.', 'playrex' ),
				'dynamic' 		=> ['active' => true ],
			]
        );
        /*  --------------- End Content Section ---------------*/
        $this->end_controls_section();

        /*  --------------- Icon Section ---------------*/
        $this->start_controls_section(
			'style_feature_icon_box',
			[
				'label'		 	=> __( 'Image Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'style_iconbox_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'style_iconbox_hover_color',
            [
                'label'     => __('Background Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-style1:hover .feature-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        /*  --------------- End Icon Section ---------------*/

        /*  --------------- Icon Title Section ---------------*/ 
        $this->start_controls_section(
			'style_iconbox_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'style_icon_title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-style1 .feature-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'iconbox_title_typography',
				'label' 		=> __( 'Title Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .feature-style1 .feature-title',
			] 
		);
        $this->add_responsive_control(
			'iconbox_title_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style1 .feature-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Icon Title Section ---------------*/

        /*  --------------- Icon Sub Title Section ---------------*/
        $this->start_controls_section(
			'style_iconbox_subtitle',
			[
				'label'		 	=> __( 'Content', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'style_icon_ubtitle_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-style1 .feature-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'iconbox_sub_title_typography',
				'label' 		=> __( 'Title Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .feature-style1 .feature-text',
			]
		);
        $this->end_controls_section();
        /*  --------------- Icon Sub Title Section ---------------*/

        

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
	    ?>
			<div class="feature-style1">
				<?php if(!empty($settings['feature_icon'])): ?>
					<div class="feature-icon">
						<?php 
							echo playrex_img_tag([
								'url' => $settings['feature_icon']['url'],
							]);
						?>
					</div>
				<?php endif; ?>
				<?php if(!empty($settings['iconbox_title'])): ?>
					<h3 class="feature-title h5">
						<?php echo esc_html($settings['iconbox_title'] ); ?>
					</h3>
				<?php endif; ?>
				<?php if(!empty($settings['iconbox_contnet'])): ?>
					<p class="feature-text">
						<?php echo esc_html($settings['iconbox_contnet']); ?>
					</p>
				<?php endif; ?>
			</div>
        <?php
	}
}