<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Imagebox extends Widget_Base {

	public function get_name() {
		return 'playrexpriimagebox';
	}

	public function get_title() {
		return __( 'Image Box', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'imagebox','playrex', 'imagebox' ];
	}

	protected function register_controls() {

		

		$this->start_controls_section(
			'playrex_imagebox',
			[
				'label' 	=> __( 'Image Box', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );



		$this->add_control(
			'image_box_version',
			[
				'label' => __('Image Box Style', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style-one',
				'options' => [
					'style-one'   => __('Style One', 'playrex'),
					'style-two'   => __('Style Two', 'playrex'),
					'style-three' => __('Style Three', 'playrex'),
					'style-four'  => __('Style Four', 'playrex'),
				],
			]
		);

        $this->add_control(
			'box_image',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'box_image_two',
			[
				'label' 		=> __( 'Image Two', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
                    'image_box_version!'    => ['style-three', 'style-four'],
                ]
			]
		);
		$this->add_control(
			'iamge_box_video_url',
			[
				'label' 	=> __( 'Video Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
				'condition' => [
                    'image_box_version'    => ['style-three', 'style-four'],
                ]
			]
        );
        $this->end_controls_section();

    }
	protected function render() {

        $settings = $this->get_settings_for_display();
		$image_box_version = $settings['image_box_version'];
		
		?>
			<div class="image-box-wraper">
				<?php if ($image_box_version): ?>
					<?php include('image-box/' . $image_box_version . '.php'); ?>
				<?php endif; ?>
			</div>
		<?php
	}
}