<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Playermatch Box Widget .
 *
 */

class Playrex_Image_slider extends Widget_Base {

	public function get_name() {
		return 'playrexplayerimageslider';
	}

	public function get_title() {
		return __( 'Image Slider', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'palyer','Image', 'Image' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_featurematch',
			[
				'label' 	=> __( 'Player  Image Slider', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		/*  --------------- Repeater Section ---------------*/
        $playerimage_repeater = new Repeater();

        /*  --------------- Player  Image Slider Section ---------------*/
		$playerimage_repeater->add_control(
			'slider_image',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_Image_src(),
				],
			]
		);
		
		$this->add_control(
			'playerimage_repeater',
			[
				'label' 		=> __( 'Player Image Slider', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $playerimage_repeater->get_controls(),
				'default' 		=> [
					[
						
                        'slider_image' 	       => Utils::get_placeholder_Image_src(),
					],
					[
						
                        'slider_image' 	       => Utils::get_placeholder_Image_src(),
					],
					[
						
                        'slider_image' 	       => Utils::get_placeholder_Image_src(),
					],
					
				],
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Playermatch Style ---------------*/
        

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        // data-fade="true" data-dots="true"

		$playerimage_repeaters = $settings['playerimage_repeater'];
		
        ?>
            <div class="match-iamge-slider">
                <?php foreach($playerimage_repeaters as $playerimage_repeater): ?>
                    <div>
                        <div class="mb-30">
                            <?php
                                echo playrex_img_tag([
                                    'url' => $playerimage_repeater['slider_image']['url'],
                                    'class' => 'w-100',
                                ]);
                            ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
			
		<?php
        
	}
}