<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Livestreaimg extends Widget_Base {

	public function get_name() {
		return 'playrexprilivestreaimg';
	}

	public function get_title() {
		return __( 'Live Streaming', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'livestreaimg','playrex', 'slider' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_livestreaimg',
			[
				'label' 	=> __( 'Livestreaimg', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		

		/*  --------------- Repeater Section ---------------*/

        $livestreaimg_repeater = new Repeater();

        /*  --------------- Feature Match Section ---------------*/

		$livestreaimg_repeater->add_control(
			'livestreaimg_background',
			[
				'label' 		=> __( 'Background Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$livestreaimg_repeater->add_control(
			'livestreaimg_image',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$livestreaimg_repeater->add_control(
			'livestreaimg_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		
		$livestreaimg_repeater->add_control(
			'livestreaimg_video_url',
			[
				'label' 	=> __( 'Box Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$this->add_control(
			'livestreaimg_repeaters',
			[
				'label' 		=> __( 'Match', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $livestreaimg_repeater->get_controls(),
				'default' 		=> [
					[
						'livestreaimg_title'         => __( 'Rabbits', 'playrex' ),
                        'livestreaimg_video_url'   => __( 'youtube.com/watch?v=_sI_Ps7JSEk', 'playrex' ),
                        'livestreaimg_background'  => Utils::get_placeholder_image_src(),
                        'livestreaimg_image' 	   => Utils::get_placeholder_image_src(),

                    ],
				],
				'title_field' 	=> '{{{ livestreaimg_title }}}',
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Featurematch Style ---------------*/

		/*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );


        $this->add_control(
            'shape_color',
            [
                'label'     => __('Shape Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-style4 .livestreaimg-shape1, {{WRAPPER}} .livestreaimg-style4' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-name .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .livestreaimg-name',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

		/*  --------------- Dis Style ---------------*/
		$this->start_controls_section(
			'dis_title',
			[
				'label'		 	=> __( 'Discription', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'livestreaimg_dis_color',
            [
                'label'     => __('Info label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .livestreaimg-text' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'dis_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .livestreaimg-text',
			]
		);

		$this->end_controls_section();
		/*  --------------- Dis Style ---------------*/

		/*  --------------- Livestreaimg Label ---------------*/
        $this->start_controls_section(
			'livestreaimg_label_title',
			[
				'label'		 	=> __( 'Livestreaimg Label', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'livestreaimg_label_color',
            [
                'label'     => __('Info label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .livestreaimg-info-label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'livestreaimg_info_color',
            [
                'label'     => __('Info Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .livestreaimg-info-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'livestreaimg_label_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .livestreaimg-info-label',
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'livestreaimg_info_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .livestreaimg-info-text',
			]
		);
        $this->end_controls_section();
        /*  --------------- Livestreaimg Label ---------------*/


		

		/*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'fm_button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'fm_button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'fm_button_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
            'fm_button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'fm_button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_responsive_control(
			'fm_button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'fm_button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'fm_button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'fm_button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

		/*  ---------------  nav Style ---------------*/
        $this->start_controls_section(
			'fm_nav_style',
			[
				'label'		 	=> __( 'Arrow', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs( 'fm_nav_tabs' );

		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'fm_nav_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
            'fm_nav_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-nav-slide .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_nav_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-nav-slide .slick-arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'fm_nav_Hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'fm_nav_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-nav-slide .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_nav_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .livestreaimg-nav-slide .slick-arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();



    }

	protected function render() {

        $settings = $this->get_settings_for_display();
		$livestreaimg_repeaters = $settings['livestreaimg_repeaters'];

        ?>
        
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="livetreaming-nav " id="videoslide1" data-asnavfor=".video-nav1">
                    <?php foreach( $livestreaimg_repeaters as $livestreaimg_repeater ): ?>
                        <div>
                            <div class="video-style1">
                                <?php if( ! empty( $livestreaimg_repeater['livestreaimg_title'] ) ): ?>
                                    <span class="video-title">
                                        <?php echo esc_html($livestreaimg_repeater['livestreaimg_title']); ?>
                                    </span>
                                <?php endif; ?>

                                <div class="video-shape">
                                    <?php
                                        echo playrex_img_tag([
                                            'url' => $livestreaimg_repeater['livestreaimg_background']['url'],
                                        ]);
                                    ?>
                                </div>
                                <div class="video-img">
                                    <?php
                                        echo playrex_img_tag([
                                            'url' => $livestreaimg_repeater['livestreaimg_image']['url'],
                                        ]);
                                    ?>
                                </div>
                                <?php if( ! empty( $livestreaimg_repeater['livestreaimg_video_url'] ) ): ?>
                                    <a href="<?php echo esc_url( $livestreaimg_repeater['livestreaimg_video_url'] ); ?>"
                                        class="play-btn style3 popup-video">
                                        <i class="fas fa-play"></i>
                                    </a>
                                <?php endif; ?>

                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="row video-nav1 gx-8 livetreaming-content" data-asnavfor="#videoslide1"  >
                    <?php foreach( $livestreaimg_repeaters as $livestreaimg_repeater ): ?>
                        <div class="col-xl-3">
                            <div class="thumb">
                                <div class="img">
                                    <?php
                                        echo playrex_img_tag([
                                            'url' => $livestreaimg_repeater['livestreaimg_image']['url'],
                                        ]);
                                    ?>
                                </div>
                                <?php if(!empty($livestreaimg_repeater['livestreaimg_title']) ): ?>
                                    <span class="title"><?php echo esc_html($livestreaimg_repeater['livestreaimg_title']); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
        
	}
}