<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Match_Body extends Widget_Base {

	public function get_name() {
		return 'playrexmatchbody';
	}

	public function get_title() {
		return __( 'Match Body', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'matchbody', 'match', 'details', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_matchbody',
			[
				'label'		 	=> __( 'Match Body', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        /*  --------------- Top Section ---------------*/
      
        $this->add_control(
			'single_page_url_one',
			[
				'label' 	=> __( 'Details Url One', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '#', 'playrex' ),
                'label_block'   => true,
			]
        );

        $this->add_control(
			'team_one_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'matchbody_time',
			[
				'label' 	=> __( 'Match Time Duration', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '02:02', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'team_two_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'single_page_url_two',
			[
				'label' 	=> __( 'Details Url Two', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '#', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->end_controls_section();

        /*  --------------- Icon Title Section ---------------*/ 
        $this->start_controls_section(
			'date_title',
			[
				'label'		 	=> __( 'Date', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'date_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} match-time' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'date_typography',
				'label' 		=> __( 'Title Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} match-time',
			] 
		);
        $this->add_responsive_control(
			'date_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} match-time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Icon Title Section ---------------*/

       


        /*  --------------- End Button Style ---------------*/

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $team_one_thumb  = $settings['team_one_thumb'];
        $matchbody_time  = $settings['matchbody_time'];
        $team_two_thumb  = $settings['team_two_thumb'];
        $single_page_url_one = $settings['single_page_url_one'];
        $single_page_url_two = $settings['single_page_url_two'];


        ?>
        <div>
            <div class="match-style2 layout3">
                <div class="match-body">

                    <?php if(!empty($team_one_thumb['url'])): ?>
                        <div class="match-team">
                            <div class="team-logo">
                                <a href="<?php echo esc_url($single_page_url_one); ?>">
                                    <?php 
                                        echo playrex_img_tag([
                                            'url' => $team_one_thumb['url'],
                                        ]);
                                    ?>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($matchbody_time)): ?>
                        <div class="match-middle">
                            <div class="match-time">
                                <?php echo esc_html($matchbody_time); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($team_two_thumb['url'])): ?>
                        <div class="match-team">
                            <div class="team-logo">
                                <a href="<?php echo esc_url($single_page_url_two); ?>">
                                    <?php 
                                            echo playrex_img_tag([
                                                'url' => $team_two_thumb['url'],
                                            ]);
                                        ?>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php
	}
}