<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Playermatch Box Widget .
 *
 */

 
class Playrex_3d_slider extends Widget_Base {

	public function get_name() {
		return 'playrexplayer3dslider';
	}

	public function get_title() {
		return __( 'Player 3D Slider', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'palyer','3D', '3d' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_featurematch',
			[
				'label' 	=> __( 'Player  3D Slider', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		/*  --------------- Repeater Section ---------------*/

        $player3d_repeater = new Repeater();

        /*  --------------- Player  3D Slider Section ---------------*/

		$player3d_repeater->add_control(
			'slider_image',
			[
				'label' 		=> __( ' 3D Slider Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$player3d_repeater->add_control(
			'slider_image_logo',
			[
				'label' 		=> __( 'Team Logo', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$player3d_repeater->add_control(
			'player_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$player3d_repeater->add_control(
			'3dslider_page_url',
			[
				'label' 	=> __( 'Single Page Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$player3d_repeater->add_control(
			'player_subtitle',
			[
				'label' 	=> __( 'Sub Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        

		$player3d_repeater->add_control(
			'player_facebook',
			[
				'label' 	=> __( 'Facebook Icon Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$player3d_repeater->add_control(
			'player_twitter',
			[
				'label' 	=> __( 'Twitter', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$player3d_repeater->add_control(
			'player_instagram',
			[
				'label' 	=> __( 'Instagram', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        // profil url
		$player3d_repeater->add_control(
			'player_facebook_url',
			[
				'label' 	=> __( 'Facebook Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$player3d_repeater->add_control(
			'player_twitter_url',
			[
				'label' 	=> __( 'Twitter', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$player3d_repeater->add_control(
			'player_instagram_url',
			[
				'label' 	=> __( 'Instagram', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$this->add_control(
			'player3d_repeater',
			[
				'label' 		=> __( 'Player 3D Slider', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $player3d_repeater->get_controls(),
				'default' 		=> [
					[
						
                        'slider_image' 	       => Utils::get_placeholder_image_src(),
                        'slider_image_logo'    => Utils::get_placeholder_image_src(),
                        'player_title'         => __( 'Jerezzy Lamot', 'playrex' ),
                        'player_subtitle'      => __( 'Team Leader', 'playrex' ),
                        'player_facebook'      => __( 'fab fa-facebook-f', 'playrex' ),
                        'player_twitter'       => __( 'fab fa-twitter', 'playrex' ),
                        'player_instagram'     => __( 'fab fa-instagram', 'playrex' ),
                        'player_facebook_url'  => __( '#', 'playrex' ),
                        'player_twitter_url'   => __( '#', 'playrex' ),
                        'player_instagram_url' => __( '#', 'playrex' ),
                        '3dslider_page_url'    => __('#', 'playrex')
					],
					[
						
                        'slider_image' 	       => Utils::get_placeholder_image_src(),
                        'slider_image_logo'    => Utils::get_placeholder_image_src(),
                        'player_title'         => __( 'Stamenic Daniejel', 'playrex' ),
                        'player_subtitle'      => __( 'Senior Team Player', 'playrex' ),
                        'player_facebook'      => __( 'fab fa-facebook-f', 'playrex' ),
                        'player_twitter'       => __( 'fab fa-twitter', 'playrex' ),
                        'player_instagram'     => __( 'fab fa-instagram', 'playrex' ),
                        'player_facebook_url'  => __( '#', 'playrex' ),
                        'player_twitter_url'   => __( '#', 'playrex' ),
                        'player_instagram_url' => __( '#', 'playrex' ),
                        '3dslider_page_url'    => __('#', 'playrex')
					],
					[
						
                        'slider_image' 	       => Utils::get_placeholder_image_src(),
                        'slider_image_logo'    => Utils::get_placeholder_image_src(),
                        'player_title'         => __( 'Accidental Genius', 'playrex' ),
                        'player_subtitle'      => __( 'Senior Team Player', 'playrex' ),
                        'player_facebook'      => __( 'fab fa-facebook-f', 'playrex' ),
                        'player_twitter'       => __( 'fab fa-twitter', 'playrex' ),
                        'player_instagram'     => __( 'fab fa-instagram', 'playrex' ),
                        'player_facebook_url'  => __( '#', 'playrex' ),
                        'player_twitter_url'   => __( '#', 'playrex' ),
                        'player_instagram_url' => __( '#', 'playrex' ),
                        '3dslider_page_url'    => __('#', 'playrex')
					],
					[
						
                        'slider_image' 	       => Utils::get_placeholder_image_src(),
                        'slider_image_logo'    => Utils::get_placeholder_image_src(),
                        'player_title'         => __( 'Vivi Marian', 'playrex' ),
                        'player_subtitle'      => __( 'Top Game Player', 'playrex' ),
                        'player_facebook'      => __( 'fab fa-facebook-f', 'playrex' ),
                        'player_twitter'       => __( 'fab fa-twitter', 'playrex' ),
                        'player_instagram'     => __( 'fab fa-instagram', 'playrex' ),
                        'player_facebook_url'  => __( '#', 'playrex' ),
                        'player_twitter_url'   => __( '#', 'playrex' ),
                        'player_instagram_url' => __( '#', 'playrex' ),
                        '3dslider_page_url'    => __('#', 'playrex')
					],
					[
						
                        'slider_image' 	       => Utils::get_placeholder_image_src(),
                        'slider_image_logo'    => Utils::get_placeholder_image_src(),
                        'player_title'         => __( 'Sick Rebellious', 'playrex' ),
                        'player_subtitle'      => __( 'Pro Team Player', 'playrex' ),
                        'player_facebook'      => __( 'fab fa-facebook-f', 'playrex' ),
                        'player_twitter'       => __( 'fab fa-twitter', 'playrex' ),
                        'player_instagram'     => __( 'fab fa-instagram', 'playrex' ),
                        'player_facebook_url'  => __( '#', 'playrex' ),
                        'player_twitter_url'   => __( '#', 'playrex' ),
                        'player_instagram_url' => __( '#', 'playrex' ),
                        '3dslider_page_url'    => __('#', 'playrex')
					],
				],
				'title_field' 	=> '{{{ player_title }}}',
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Playermatch Style ---------------*/

		/*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( ' 3D Slider Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-title .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .player-style2 .player-title',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

		/*  --------------- Designation ---------------*/
        $this->start_controls_section(
			'player_designation_title',
			[
				'label'		 	=> __( 'Designation' , 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'player_designation_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-degi' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'player_designation_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .player-style2 .player-degi',
			]
		);
        $this->end_controls_section();
        /*  --------------- Designation  ---------------*/


		

		/*  --------------- Profile Style ---------------*/
		$this->start_controls_section(
			'fm_profile_style',
			[
				'label'		 	=> __( 'Pprofile', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'fm_profile_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'fm_profile_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
            'fm_profile_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-social a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_profile_border_color',
            [
                'label'     => __('Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-social a' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_profile_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-social a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
			'width',
			[
				'label' => esc_html__( 'Font Size', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .player-style2 .player-social a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'fm_profile_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .player-style2 .player-social a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'fm_button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'fm_button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-social a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_profile_border_hover_color',
            [
                'label'     => __('Border Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-social a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style2 .player-social a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Profile Style ---------------*/
        

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$player3d_repeaters = $settings['player3d_repeater'];
		
        ?>
            <div class="slick-3d-active" id="playeravater1">
                <?php foreach( $player3d_repeaters as $player3d ): ?>
                    <?php if( ! empty( $player3d['slider_image']['url'] ) ): ?>
                    <div class="slick-3d">
                        <div class="player-avater1">
                            <?php
                                echo playrex_img_tag([
                                    'url' => $player3d['slider_image']['url'],
                                ]);
                            ?>
                        </div>
                    </div>
                <?php endif; endforeach; ?>
            </div>

            <div class="player-slider1">
                <?php foreach($player3d_repeaters as $player3d): ?>
                    <div>
                        <div class="player-style2">
                            <div class="player-content">
                                <?php if(!empty($player3d['slider_image_logo']['url'])): ?>
                                    <div class="player-team-logo">
                                        <?php
                                            echo playrex_img_tag([
                                                'url' => $player3d['slider_image_logo']['url'],
                                            ]);
                                        ?>
                                    </div>
                                <?php endif; ?>
                                        
                                <?php if(!empty($player3d['player_title'])): ?>
                                    <h3 class="player-title">
                                        <a href="<?php echo esc_url($player3d['3dslider_page_url']) ?>" class="text-inherit">
                                            <?php echo esc_html($player3d['player_title']) ?>
                                        </a>
                                    </h3>
                                <?php endif; ?>
                                <?php if(!empty($player3d['player_subtitle'])): ?>
                                    <p class="player-degi">
                                        <?php echo esc_html($player3d['player_subtitle']) ?>
                                    </p>
                                <?php endif; ?>

                                <div class="player-social">
                                    <?php if(!empty($player3d['player_facebook'])): ?>
                                        <a href="<?php echo esc_url($player3d['player_facebook_url']); ?>">
                                            <i class="<?php echo esc_attr($player3d['player_facebook']) ?>"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(!empty($player3d['player_twitter'])): ?>
                                        <a href="<?php echo esc_url($player3d['player_twitter_url']); ?>">
                                            <i class="<?php echo esc_attr($player3d['player_twitter']) ?>"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(!empty($player3d['player_instagram'])): ?>
                                        <a href="<?php echo esc_url($player3d['player_instagram_url']); ?>">
                                            <i class="<?php echo esc_attr($player3d['player_instagram']) ?>"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
			
		<?php
        
	}
}