<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Button Box Widget .
 *
 */
class Playrex_Button extends Widget_Base {

	public function get_name() {
		return 'playrexpributton';
	}

	public function get_title() {
		return __( 'Button', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-button playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'button', 'line-button', 'playrex', 'btn' ];
	}

	protected function register_controls() {


		$this->start_controls_section(
			'playrex_button',
			[
				'label' 	=> __( 'Button', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );


		$this->add_control(
            'button_version',
            [
                'label'   => __( 'Button Style', 'playrex' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style-one'   => 'Default',
                    'style-two'   => 'Style Two',
                ],
                'default' => 'style-one',
            ]
        );

		$this->add_responsive_control(
            'button_align',
            [
                'label' => __('Align', 'fugu-hp'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'fugu-hp'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('top', 'fugu-hp'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'fugu-hp'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
				'selectors' => [
                    '{{WRAPPER}} .playrex-btn-wraper' => 'text-align: {{VALUE}}',
                ],
                'toggle' => true,
            ]
        );
        $this->add_control(
			'show_icon',
			[
				'name'         => 'Show Icon',
				'label'        => esc_html__( 'Show Icon', 'playrex' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes'
			]
        );
        $this->add_control(
			'button_size',
			[
				'label' => __('Button Size', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'd-block'  => __('Full Width', 'playrex'),
					'default' => __('Default', 'playrex'),
				],
			]
		);
        $this->add_control(
			'button_type',
			[
				'label' 	=> __('Button Type', 'playrex'),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'link',
				'options' 	=> [
					'video'  	=> __('Video Button', 'playrex'),
					'link' 		=> __('Link Button', 'playrex'),
				],
			]
		);
        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Button Text', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'video_url',
			[
				'label' 	=> __( 'Video Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
                'condition' => ['button_type' => 'video'],
			]
        );
        $this->add_control(
			'button_url',
			[
				'label' => __('URL', 'playrex'),
				'type' =>  Controls_Manager::URL,
				'condition' => ['button_type' => 'link'],
			]
		);

        $this->end_controls_section();
		
        /*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'button_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .playrex-btn',
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .playrex-btn, {{WRAPPER}} .header-strem-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-btn:after, {{WRAPPER}} .playrex-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

    }

	
	protected function render() {

        $settings = $this->get_settings_for_display();
        $url = '';

        if( 'link' == $settings['button_type'] ){
            $this->add_render_attribute( 'wrapper', 'href', $settings['button_url']['url'] );
			
			if( ! empty( $settings['button_url']['nofollow'] ) ) {
				$this->add_render_attribute( 'wrapper', 'rel', 'nofollow' );
			}
	
			if( ! empty( $settings['button_url']['is_external'] ) ) {
				$this->add_render_attribute( 'wrapper', 'target', '_blank' );
			}
			
			if( $settings['button_version'] == 'style-two' ){
				$this->add_render_attribute( 'wrapper', 'class', 'header-strem-btn' );
			}else{
				$this->add_render_attribute( 'wrapper', 'class', 'vs-btn playrex-btn' );
			}
        }else{
            $url      = $settings['video_url'];
            $this->add_render_attribute( 'wrapper', 'href', $url );
            $this->add_render_attribute( 'wrapper', 'class', 'vs-btn playrex-btn popup-video' );
        }
		
        $this->add_render_attribute( 'wrapper', 'class', $settings['button_size'] );

        ?>
            <?php if($settings['button_text']): ?>
				<div class="playrex-btn-wraper">
					<a <?php echo  $this->get_render_attribute_string('wrapper') ?> >
						<?php if( $settings['show_icon'] == 'yes' ): ?>
							<i class="fab fa-twitch"></i>
						<?php endif; ?>
						<?php echo esc_html($settings['button_text']); ?>
					</a>
				</div>
              
            <?php endif; ?>
        <?php
	}
}