<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Cta extends Widget_Base {

	public function get_name() {
		return 'playrexpricta';
	}

	public function get_title() {
		return __( 'Cta', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'cta','playrex', 'content box' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_cta',
			[
				'label' 	=> __( 'Cta Box', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_responsive_control(
            'cta_version',
            [
                'label' => __( 'Show Items', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => '1',
                'options'            => [
                    '1' => 'Style 01',
                    '2' => 'Style 02',
                ],
                'frontend_available' => true,
            ]
			
        );

        $this->add_control(
			'cta_background',
			[
				'label' 		=> __( 'Background Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'cta_background_right',
			[
				'label' 		=> __( 'Right Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
                'condition'	=> [ 'cta_version' => '2' ],
			]
		);
        $this->add_control(
			'cta_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'   => __('Ready to Start Your Journey?'),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'sub_title',
			[
				'label' 	=> __( 'Subt Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'   => __('Ready to Start Your Journey?'),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
                'default'   => __('Register Now', 'playrex'),
			]
        );

        $this->add_control(
			'button_url',
			[
				'label' => __('URL', 'playrex'),
				'type' =>  Controls_Manager::URL,
			]
		);
        $this->end_controls_section();


        /*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'button_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn.style3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_bordercolor',
            [
                'label'     => __('Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn.style3' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn.style3' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .vs-btn.style3',
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn.style3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn.style3:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn.style3:after, {{WRAPPER}} .vs-btn.style3:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

         /*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'cta_title_style_section',
			[
				'label' 	=> __( 'Title', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'cta_title_color',
			[
				'label' 		=> __( 'Title Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title2' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'cta_title_typography',
				'label' 	=> __( 'Title Typography', 'playrex' ),
				'selector' 	=> '{{WRAPPER}} .sec-title2',
			]
        );

        $this->add_responsive_control(
			'cta_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*  --------------- Title End Style ---------------*/

        /*  --------------- Sub Title  Style ---------------*/
        $this->start_controls_section(
			'cta_sub_title_style_section',
			[
				'label' 	=> __( 'Sub Title', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'cta_sub_title_color',
			[
				'label' 		=> __( 'Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .cta-text1' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'cta_sub_title_typography',
				'label' 	=> __( 'Typography', 'playrex' ),
				'selector' 	=> '{{WRAPPER}} .cta-text1',
			]
        );

        $this->add_responsive_control(
			'cta_sub_title_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .cta-text1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*  --------------- Sub Title End Style ---------------*/


    }
	protected function render() {

        $settings = $this->get_settings_for_display();
        $cta_version = $settings['cta_version'];
        $cta_background = $settings['cta_background'];

        $cta_title  = $settings['cta_title'];
        $sub_title = $settings['sub_title'];
        $button_text = $settings['button_text'];

        $target   = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';
        $url      = $settings['button_url']['url'];
        $this->add_render_attribute( 'wrapper', 'href', $url );
		if( ! empty( $nofollow ) ){
	        $this->add_render_attribute( 'wrapper', 'rel',  $nofollow );
		}
		if( ! empty( $target ) ){
	        $this->add_render_attribute( 'wrapper', 'target', $target );
		}
        $this->add_render_attribute( 'wrapper', 'class', 'vs-btn style3' );




		?>
            <?php if($cta_version == '1'): ?>
                <section class="cta-wrap1 z-index-common">
                    <svg class="svg-hidden">
                        <clipPath id="cta-clip1" clipPathUnits="objectBoundingBox">
                            <path
                                d="M0.984,1 H-0.004 V0.312 H-0.016 L-0.004,0.31 V0.293 H0.083 L0.791,0.158 L0.739,0.063 L0.984,0 L0.983,0.293 H0.984 V1">
                            </path>
                        </clipPath>
                    </svg>
                    <?php if(!empty($cta_background['url'])): ?>
                        <div class="cta-shape1" data-bg-src="<?php echo esc_url($cta_background['url']); ?>"></div>
                    <?php endif; ?>
                    <div class="cta-shape2"></div>
                    <div class="container">
                        <?php if(!empty($cta_title)): ?>
                            <h2 class="sec-title2 text-white mb-2">
                                <?php echo esc_html($cta_title) ?>
                            </h2>
                        <?php endif; ?>
                        <?php if(!empty($sub_title)): ?>
                            <p class="cta-text1 text-white">
                                <?php echo esc_html($sub_title); ?>
                            </p>
                        <?php endif; ?>
                        <?php if(!empty($button_text)): ?>
                            <a <?php echo  $this->get_render_attribute_string('wrapper') ?>><?php echo esc_html($button_text); ?> </a>
                        <?php endif; ?>
                    </div>
                </section>
            <?php elseif($cta_version == '2'): ?>
                <div class="bg-secondary background-image" style="background-image: url(<?php echo esc_url($cta_background['url']); ?>);">
                    <div class="row flex-row-reverse">
                        <?php if(!empty($settings['cta_background_right']['url'])): ?>
                            <div class="col-lg-7 col-xxl-auto">
                                <?php
                                    echo playrex_img_tag([
                                        'url' => $settings['cta_background_right']['url'],
                                        'class' => 'w-100',
                                    ]);
                                ?>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-5 col-xxl align-self-center text-center text-lg-start">
                            <div class="cta-about1">
                                <?php if(!empty($cta_title) ): ?>
                                    <h2 class="cta-title h1 text-white">
                                        <?php echo esc_html($cta_title); ?>
                                    </h2>
                                <?php endif; ?>
                                
                                <?php if(!empty($sub_title)): ?>
                                    <p class="cta-text text-white">
                                        <?php echo esc_html($sub_title); ?>
                                    </p>
                                <?php endif ?>

                                <?php if(!empty($button_text)): ?>
                                    <a <?php echo  $this->get_render_attribute_string('wrapper') ?>><?php echo esc_html($button_text); ?> </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
		<?php
        
	}
}