<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Faq Area Widget .
 *
 */
class Playrex_Faq_Area extends Widget_Base {

	public function get_name() {
		return 'playrexfaqarea';
	}

	public function get_title() {
		return __( 'Faq Area', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'faq_area_section',
			[
				'label' 	=> __( 'Faq Area', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$repeater = new Repeater();

        $repeater->add_control(
			'faq_title',
			[
				'label' 	=> __( 'Faq Area Plan Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'What solar panels do Solarsense install?', 'playrex' )
			]
        );

        $repeater->add_control(
			'faq_ans',
			[
				'label'         => __( 'Description', 'playrex' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'Default description', 'playrex' ),
				'placeholder'   => __( 'Yes, despite the removal of Government Feed-in Tariff, installs have been forecast to continue at the current rate and even increase in 2023.', 'playrex' ),
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'faq_title' 	=> __( 'HOW DO I PURCHASE A BOOST?', 'playrex' ),
						'faq_ans' 	    => __( 'Yes, despite the removal of Government Feed-in Tariff, installs have been forecast to continue at the current rate and even increase in 2023.', 'playrex' ),
					],
					[
						'faq_title' 	=> __( 'I DONT LIKE THE PRICE, CAN I GET A DISCOUNT?', 'playrex' ),
						'faq_ans' 	    => __( 'Yes, despite the removal of Government Feed-in Tariff, installs have been forecast to continue at the current rate and even increase in 2023.', 'playrex' ),
					],
					[
						'faq_title' 	=> __( 'HOW CAN I KNOW YOU ARE LEGIT, CAN I TRUST YOU?', 'playrex' ),
						'faq_ans' 	    => __( 'Yes, despite the removal of Government Feed-in Tariff, installs have been forecast to continue at the current rate and even increase in 2023.', 'playrex' ),
					],
					[
						'faq_title' 	=> __( 'IS BOOSTING SAFE, CAN I GET BANNED?', 'playrex' ),
						'faq_ans' 	    => __( 'Yes, despite the removal of Government Feed-in Tariff, installs have been forecast to continue at the current rate and even increase in 2023.', 'playrex' ),
					],
				],
				'title_field' 	=> '{{{ faq_title }}}',
			]
		);


        $this->end_controls_section();

        $this->start_controls_section(
			'faq_area_style_section',
			[
				'label' 	=> __( 'Faq Area Style', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        
        
        
        $this->add_control(
			'faq_area_color',
			[
				'label' 		=> __( 'Faq Area Title Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-style1 .accordion-button,{{WRAPPER}} .accordion-style2 .accordion-button' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'faq_area_typography',
				'label' 	=> __( 'Faq Area Title Typography', 'playrex' ),
                'selector' 	=> '{{WRAPPER}} .accordion-style1 .accordion-button,{{WRAPPER}} .accordion-style2 .accordion-button',
			]
        );

		$this->add_control(
			'faq_desc_color',
			[
				'label' 		=> __( 'FAQ Description Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-style1 .accordion-body p,{{WRAPPER}} .accordion-style2 .accordion-body p' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'faq_desc_typography',
				'label' 	=> __( 'FAQ Description Typography', 'playrex' ),
                'selector' 	=> '{{WRAPPER}} .accordion-style1 .accordion-body p,{{WRAPPER}} .accordion-style2 .accordion-body p',
			]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        
        $accordion = uniqid();
		
		echo '<div class="accordion accordion-style1" id="faqVersion'.$accordion.'">';
			if( ! empty( $settings['slides'] ) ){
				$x = 1;
				foreach( $settings['slides'] as $singleslide ){
					if( $x == '1' ){
						$show = 'show';
						$collapsed = '';
					}else{
						$show = '';
						$collapsed = 'collapsed';
					}
					echo '<div class="accordion-item">';
						if( ! empty( $singleslide['faq_title'] ) ){
							echo '<div class="accordion-header" id="heading'.esc_attr( $accordion.$x ).'">';
								echo '<button class="accordion-button '.esc_attr( $collapsed ).'" type="button" data-bs-toggle="collapse" data-bs-target="#collapse'.esc_attr( $accordion.$x ).'" aria-expanded="true" aria-controls="collapse'.esc_attr( $accordion.$x ).'">';
									echo esc_html( $singleslide['faq_title'] );
								echo '</button>';
							echo '</div>';
						}
						if( ! empty( $singleslide['faq_ans'] ) ){
							echo '<div id="collapse'.esc_attr( $accordion.$x ).'" class="accordion-collapse collapse '.esc_attr( $show ).'" aria-labelledby="heading'.esc_attr( $accordion.$x ).'" data-bs-parent="#faqVersion'.$accordion.'">';
								echo '<div class="accordion-body">';
									echo wp_kses_post( $singleslide['faq_ans'] );
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					$x++;
				}
			}
		echo '</div>';

	}
}