<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Featurmatch extends Widget_Base {

	public function get_name() {
		return 'playrexprifeaturematch';
	}

	public function get_title() {
		return __( 'Feature Match', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'featurematch','playrex', 'btn' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_featurematch',
			[
				'label' 	=> __( 'Feature Match', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'active_slider',
			[
				'label' 		=> __( 'Active Slider', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		/*  --------------- Repeater Section ---------------*/

        $f_match_repeater = new Repeater();

        /*  --------------- Feature Match Section ---------------*/

		$f_match_repeater->add_control(
			'match_background',
			[
				'label' 		=> __( 'Match Box Background', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$f_match_repeater->add_control(
			'match_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$f_match_repeater->add_control(
			'tournament_label_one',
			[
				'label' 	=> __( 'Tournament Label One', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$f_match_repeater->add_control(
			'tournament_info',
			[
				'label' 	=> __( 'Tournament Info One', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$f_match_repeater->add_control(
			'tournament_label_two',
			[
				'label' 	=> __( 'Tournament Label Two', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$f_match_repeater->add_control(
			'tournament_info_two',
			[
				'label' 	=> __( 'Tournament Info Two', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        $f_match_repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        $f_match_repeater->add_control(
			'button_url',
			[
				'label' 	=> __( 'Button Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$f_match_repeater->add_control(
			'fm_wraper_url',
			[
				'label' 	=> __( 'Box Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$this->add_control(
			'feature_match_repeater',
			[
				'label' 		=> __( 'Match', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $f_match_repeater->get_controls(),
				'default' 		=> [
					[
						'match_title'        => __( 'The Sims Dim', 'playrex' ),
						'tournament_label_one'         => __( '8 Groups', 'playrex' ),
						'tournament_label_two'         => __( 'Prize Pool', 'playrex' ),
                        'match_background' 	 => Utils::get_placeholder_image_src(),
                        'tournament_info'      => __( '19 Players', 'playrex' ),
                        'tournament_info_two'      => __( '$200', 'playrex' ),
                        'button_text'        => __( 'Book Now', 'playrex' ),
                        'button_url'         => __( '#', 'playrex' ),
                        'fm_wraper_url'         => __( '#', 'playrex' ),

					],
					[
						'match_title'        => __( 'HedgeHog Play', 'playrex' ),
						'tournament_label_one'         => __( '3 Groups', 'playrex' ),
						'tournament_label_two'         => __( 'Prize Pool', 'playrex' ),
                        'match_background' 	 => Utils::get_placeholder_image_src(),
                        'tournament_info'      => __( '96 Players', 'playrex' ),
                        'tournament_info_two'      => __( '$700', 'playrex' ),
                        'button_text'        => __( 'Book Now', 'playrex' ),
                        'button_url'         => __( '#', 'playrex' ),
						'fm_wraper_url'         => __( '#', 'playrex' ),

					],
					[
						'match_title'        => __( 'Call of duty', 'playrex' ),
						'tournament_label_one'         => __( '3 Groups', 'playrex' ),
						'tournament_label_two'         => __( 'Prize Pool', 'playrex' ),
                        'match_background' 	 => Utils::get_placeholder_image_src(),
                        'tournament_info'      => __( '45 Players', 'playrex' ),
                        'tournament_info_two'      => __( '$200', 'playrex' ),
                        'button_text'        => __( 'Book Now', 'playrex' ),
                        'button_url'         => __( '#', 'playrex' ),
						'fm_wraper_url'         => __( '#', 'playrex' ),

					],
				],
				'title_field' 	=> '{{{ match_title }}}',
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Featurematch Style ---------------*/

		/*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Match Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-style3 .tournament-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-style3 .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style3 .tournament-title',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

		/*  --------------- Tournament Label ---------------*/
        $this->start_controls_section(
			'tournament_label_title',
			[
				'label'		 	=> __( 'Tournament Label', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'tournament_label_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-style3 .tournament-label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_label_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style3 .tournament-label',
			]
		);
        $this->end_controls_section();
        /*  --------------- Tournament Label ---------------*/


		/*  --------------- Tournament Label ---------------*/
        $this->start_controls_section(
			'tournament_tournament_title',
			[
				'label'		 	=> __( 'Tournament Info', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'tournament_tournament_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-style3 .tournament-info' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_tournament_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style3 .tournament-info',
			]
		);
        $this->end_controls_section();
        /*  --------------- Tournament Label ---------------*/

		/*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'fm_button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'fm_button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'fm_button_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
            'fm_button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'fm_button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_responsive_control(
			'fm_button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'fm_button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'fm_button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'fm_button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

		/*  ---------------  Dots Style ---------------*/
        $this->start_controls_section(
			'fm_dots_style',
			[
				'label'		 	=> __( 'Dots', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'fm_dots_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'fm_dots_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
            'fm_dots_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots button, {{WRAPPER}} .slick-dots .slick-active button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_hover',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .slick-dots button:hover',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'fm_dots_Hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);

        $this->add_control(
            'fm_dots_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .slick-dots button:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();



    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$feature_match_repeater = $settings['feature_match_repeater'];
		
		?>

			<div class="row gx-60 align-items-center">
                <div class="col-6 col-xl-3 order-xl-1">
                    <div class="tournament-menu2 nav-prev">
						<?php foreach( $feature_match_repeater as $fm_repeater ): ?>
                        	<button class="tab-btn">
								<?php
									if( function_exists( 'playrex_img_tag' ) ){
										echo playrex_img_tag([
											'url' => $fm_repeater['match_background']['url'],
										]);
									}
								?>
							</button>
						<?php endforeach; ?>
                    </div>
                    <button type="button" class="tournament-slide-btn" data-slick-prev="#tournamentslide1"><?php _e('Prev game', 'playrex') ?></button>
                </div>

                <div class="col-6 col-xl-3  order-xl-3">
                    <div class="tournament-menu2 nav-next">
						<?php foreach( $feature_match_repeater as $fm_repeater ): ?>
                        	<button class="tab-btn">
								<?php
									if( function_exists( 'playrex_img_tag' ) ){
										echo playrex_img_tag([
											'url' => $fm_repeater['match_background']['url'],
										]);
									}
								?>
							</button>
						<?php endforeach; ?>
                    </div>

                    <button type="button" class="tournament-slide-btn" data-slick-next="#tournamentslide1"><?php _e('Next game', 'playrex') ?></button>
                </div>

                <div class="col-xl-6  order-xl-2">
                    <div id="tournamentslide1">
						<?php foreach($feature_match_repeater as $fm_repeater): ?>
							<div>
								<div class="tournament-style3">
									<?php if( ! empty($fm_repeater['match_background']['url'] ) ): ?>
										<div class="tournament-img">
											<a href="<?php echo esc_url( $fm_repeater['fm_wraper_url'] ); ?>">
												<?php
													if( function_exists( 'playrex_img_tag' ) ){
														echo playrex_img_tag([
															'url' => $fm_repeater['match_background']['url'],
														]);
													}
												?>
											</a>
										</div>
									<?php endif; ?>
									<div class="tournament-content">
										<div class="row">
											<div class="col-lg">
												<?php if(!empty($fm_repeater['match_title'])): ?>
													<h3 class="tournament-title">
														<a href="<?php echo $fm_repeater['fm_wraper_url'];?>" class="text-inherit"><?php echo esc_html($fm_repeater['match_title']); ?> </a>
													</h3>
												<?php endif; ?>
												<div class="row">
													<div class="col-6 col-md-auto">
														<?php if(!empty($fm_repeater['tournament_label_one'])): ?>
															<p class="tournament-label"><?php echo esc_html($fm_repeater['tournament_label_one']); ?></p>
														<?php endif; ?>

														<?php if(!empty($fm_repeater['tournament_info'])): ?>
															<p class="tournament-info"><?php echo esc_html($fm_repeater['tournament_info']); ?></p>
														<?php endif; ?>
													</div>
													<div class="col-6 col-md-auto">
														<?php if( ! empty($fm_repeater['tournament_label_two'] ) ): ?>
															<p class="tournament-label"><?php echo esc_html( $fm_repeater['tournament_label_two'] ); ?></p>
														<?php endif; ?>

														<?php if(!empty($fm_repeater['tournament_info_two'])): ?>
															<p class="tournament-info"><?php echo esc_html($fm_repeater['tournament_info_two']); ?></p>
														<?php endif; ?>
													</div>
												</div>
											</div>
											<div class="col-lg-auto align-self-end">
												<?php if( ! empty( $fm_repeater['button_text'] ) ): ?>
													<a href="<?php echo esc_url( $fm_repeater['button_url'] ); ?>" class="vs-btn"><?php echo esc_html( $fm_repeater['button_text'] ); ?></a>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
                    </div>
                </div>
            </div>
		<?php
        
	}
}