<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Gallery extends Widget_Base {

	public function get_name() {
		return 'playrexgallery';
	}

	public function get_title() {
		return __( 'Image Gallery', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'gallery', 'popup', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_gallery',
			[
				'label'		 	=> __( 'Image Gallry', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		
		$this->add_responsive_control(
            'gallery_version',
            [
                'label' => __( 'Show Items', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => '1',
                'options'            => [
                    '1' => 'Style 01',
                    '2' => 'Style 02',
                    '3' => 'Style 03',
                ],
                'frontend_available' => true,
            ]
			
        );

		$this->add_control(
			'g_active_slider',
			[
				'name'         => 'slider_active',
				'label'        => esc_html__( 'Slider Active?', 'playrex' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'	=> [ 'gallery_version!' => '3' ],
			]
        );

		$this->add_control(
			'top_text',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __('Instagram Photos', 'playrex'),
                'label_block'   => true,
				'condition'		=> [ 'gallery_version' => '2' ],
			]
        );

		$this->add_control(
			'left_text',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __('FOLLOW @INSTAGRAM', 'playrex'),
                'label_block'   => true,
				'condition'		=> [ 'gallery_version' => '3' ],
			]
        );

		$this->add_control(
			'left_icon',
			[
				'label' 	=> __( 'Icon Nmae', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
				'default'   => __('fab fa-instagram', 'playrex'),
                'label_block'   => true,
				'condition'		=> [ 'gallery_version' => '3' ],
			]
        );

		$this->add_control(
			'bottom_text',
			[
				'label' 	=> __( 'Botoom Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
				'default'   => __('@instagram', 'playrex'),
                'label_block'   => true,
				'condition'		=> [ 'gallery_version' => '2' ],
			]
        );


		$this->add_responsive_control(
            'column_size',
            [
                'label' => __( 'Show Items', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => '3',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
				'condition'		=> [ 'g_active_slider!' => 'yes',  'gallery_version!' => '3'],
				'selectors'      => [
                    '{{WRAPPER}} .sidebar-gallery:not(.vs-carousel)' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                ],
            ]
			
        );

        /*  --------------- Repeater Section ---------------*/
        $gallery_repeater = new Repeater();

        $gallery_repeater->add_control(
			'gallery_image',
			[
				'label' 	=> __( 'Image', 'playrex' ),
                'type' 		=> Controls_Manager::MEDIA,
                'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
		$gallery_repeater->add_control(
			'gallery_icon',
			[
				'name'         => 'gallery_icon',
				'label'        => esc_html__( 'Show?', 'playrex' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes'
			]
        );
        
        $this->add_control(
			'gallery_repeater',
			[
				'label' 		=> __( 'Icon Box', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $gallery_repeater->get_controls(),
				'default' 		=> [
					[
						'gallery_image'  => Utils::get_placeholder_image_src(),
						'gallery_icon'   => __('yes', 'playrex'),
					],
					[
						'gallery_image'  => Utils::get_placeholder_image_src(),
						'gallery_icon'   => __('yes', 'playrex'),
					],
					[
						'gallery_image'  => Utils::get_placeholder_image_src(),
						'gallery_icon'   => __('yes', 'playrex'),
					],
					[
						'gallery_image'  => Utils::get_placeholder_image_src(),
						'gallery_icon'   => __('yes', 'playrex'),
					],
					[
						'gallery_image'  => Utils::get_placeholder_image_src(),
						'gallery_icon'   => __('yes', 'playrex'),
					],
					[
						'gallery_image'  => Utils::get_placeholder_image_src(),
						'gallery_icon'   => __('yes', 'playrex'),
					],
				],
			]
		);
        /*  --------------- End Repeater Section ---------------*/


        $this->end_controls_section();

		/*  --------------- Slider Settings ---------------*/
    

        $this->start_controls_section(
			'g_slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
                'condition'		=> [ 'g_active_slider' => 'yes' ]
			]
        );

		$this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 6,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
	

		$this->add_control(
			'g_slider_autoplay',
			[
				'label' 		=> __( 'AutoPlay', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Slider Settings ---------------*/


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		$gallery_repeater = $settings['gallery_repeater'];

		if( 'yes' == $settings['g_active_slider']){
            $this->add_render_attribute( 'wrapper', 'class', ['row gx-20 sidebar-gallery vs-carousel'] );
            if($settings['g_slider_autoplay'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'false' );
            }
            $this->add_render_attribute( 'wrapper', 'data-slide-to-show',  $settings['per_coulmn']);
            
        }else{
			$this->add_render_attribute( 'wrapper', 'class', ['gx-20 sidebar-gallery'] );
        }


		
        ?>

		
		<?php if( 1  ==  $settings['gallery_version'] ): ?>
			<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
				<?php foreach($gallery_repeater as $gr): ?>
					<div class="col">
						<div class="gallery-thumb"> 
							<?php 
								echo playrex_img_tag([
									'url' => $gr['gallery_image']['url'],
								]);
							?>
							<a href="<?php echo esc_url($gr['gallery_image']['url']) ?>" class="popup-image gal-btn"><i
								class="fab fa-instagram"></i>
							</a>
						</div>
					</div>
				<?php endforeach; ?>
			</div>     
			<?php elseif( 2  ==  $settings['gallery_version']): ?>
				<div class="gallery-wrap1">
					<?php if(!empty('top_text') ): ?>
						<span class="sec-subtitle text-white">
							<?php echo esc_html($settings['top_text'] ); ?>
						</span>
					<?php endif; ?>
					<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
						<?php foreach($gallery_repeater as $gr): ?>
							
							<div class="col">
								<div class="gallery-style1">
									<div class="gallery-img">
										<a href="<?php echo esc_url($gr['gallery_image']['url']) ?>" class="popup-image">
										<?php 
											echo playrex_img_tag([
												'url' => $gr['gallery_image']['url'],
											]);
											?>
										</a>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>

					<?php if($settings['bottom_text']): ?>
						<p class="follow-text text-white">
							<?php echo wp_kses_post($settings['bottom_text']); ?>						
						</p>
					<?php endif; ?>

				</div>
			<?php elseif(3  ==  $settings['gallery_version']): ?>
				<div class="row gx-0 justify-content-center justify-content-xl-start">
                    <div class="col-xl-5">
                        <div class="follow-box">

							<?php if(!empty($settings['left_icon'] ) ): ?>
                            	<div class="follow-box__icon">
									<i class="<?php echo esc_attr($settings['left_icon']) ?>"></i>
								</div>
							<?php endif; ?>

							<?php if(!empty($settings['left_text'] ) ): ?>
								<h3 class="follow-box__title">
									<?php echo esc_html($settings['left_text'] ); ?>
								</h3>
							<?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-11 col-xl-7 align-self-center z-index-common">
                        <div class="row gx-3 gy-gx">

							<?php foreach($gallery_repeater as $gr): ?>
								<div class="col-6 col-md-4">
									<div class="gallery-style1">
										<div class="gallery-img">
										<a href="<?php echo esc_url($gr['gallery_image']['url']) ?>" class="popup-image">
											<?php 
												echo playrex_img_tag([
													'url' => $gr['gallery_image']['url'],
													'class' => 'w-100',
												]);
												?>
											</a>
										</div>
									</div>
								</div>
							<?php endforeach; ?>

                        </div>
                    </div>
                </div>
			<?php endif; ?>

		<?php
		
	}
}