<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Icon_Box extends Widget_Base {

	public function get_name() {
		return 'playrexsiconbox';
	}

	public function get_title() {
		return __( 'Icon Box', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'icon box', 'box', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_icon_box',
			[
				'label'		 	=> __( 'Icon Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        /*  --------------- Content Section ---------------*/

		$this->add_control(
			'icon_box_style',
			[
				'label' => __('Style', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'   => __('Default', 'playrex'),
					'2' => __('Style Two', 'playrex'),
					'3' => __('Style Three', 'playrex'),
				],
			]
		);

		$this->add_control(
			'icon_box_type',
			[
				'label' => __('Icon Type', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
				'options' => [
					'icon'  => __('Icon', 'playrex'),
					'iamge' => __('Iamge', 'playrex'),
				],
			]
		);

        $this->add_control(
			'iconbox_icon',
			[
				'label' 	=> __( 'Icon', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'fab fa-twitch', 'playrex' ),
				'dynamic' 		=> ['active' => true ],
				'condition' => ['icon_box_type' => 'icon'],
			]
        );

		$this->add_control(
			'icon_box_image',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' 		=> ['active' => true ],
				'condition' => ['icon_box_type' => 'iamge'],
			]
		);

        $this->add_control(
			'iconbox_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '1300+', 'playrex' ),
				'dynamic' 		=> ['active' => true ],
			]
        );
        $this->add_control(
			'iconbox_sub_title',
			[
				'label' 	=> __( 'Sub Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'TWITCH STREAMS', 'playrex' ),
				'dynamic' 		=> ['active' => true ],
			]
        );
        /*  --------------- End Content Section ---------------*/
        $this->end_controls_section();


        /*  --------------- Container Section ---------------*/
		$this->start_controls_section(
			'style_icon_wraper',
			[
				'label'		 	=> __( 'Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
				'condition' => ['icon_box_style' => '2'],
			]
        );
		$this->add_responsive_control(
			'style_icon_box_p',
			[
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .counter-style2' => 'align-items: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'style_iconwraper_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .counter-style2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- Container end ---------------*/

        /*  --------------- Icon Section ---------------*/
        $this->start_controls_section(
			'style_icon_box',
			[
				'label'		 	=> __( 'Icon', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'style_icon_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'style_iconbox_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'style_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'style_icon_p',
			[
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .counter-icon' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'style_iconbox_size',
			[
				'label' => esc_html__( 'Box Size', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'style_iconbox_line_height',
			[
				'label' => esc_html__( 'Line Height', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-icon' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'style_iconbox_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .counter-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->add_responsive_control(
			'style_iconbox_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .counter-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Icon Section ---------------*/

        /*  --------------- Icon Title Section ---------------*/
        $this->start_controls_section(
			'style_iconbox_title',
			[
				'label'		 	=> __( 'Counter Number', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'style_icon_title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-number' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'iconbox_title_typography',
				'label' 		=> __( 'Title Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .counter-number',
			]
		);
        $this->add_responsive_control(
			'iconbox_title_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .counter-number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Icon Title Section ---------------*/

        /*  --------------- Icon Sub Title Section ---------------*/
        $this->start_controls_section(
			'style_iconbox_subtitle',
			[
				'label'		 	=> __( 'Sub Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'style_icon_ubtitle_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'iconbox_sub_title_typography',
				'label' 		=> __( 'Title Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .counter-text',
			]
		);
        $this->end_controls_section();
        /*  --------------- Icon Sub Title Section ---------------*/

        

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

			
		if($settings['icon_box_style'] == '1'){
			$this->add_render_attribute( 'wrapper', 'class', ['text-center'] );
		}else{
			$this->add_render_attribute( 'wrapper', 'class', ['media-body']  );
		}
        ?>
			

			<?php if($settings['icon_box_style'] == '3'): ?>

				<div class="col-auto">
					<div class="tournament-media">
						<?php if( !empty( $settings['iconbox_icon'])): ?>
							<div class="media-icon">
								<i class="<?php echo esc_attr( $settings['iconbox_icon'] ); ?>"></i>
							</div>
						<?php endif; ?>
						<div class="media-body">
							<?php if( !empty( $settings['iconbox_title'])): ?>
								<span class="media-title"><?php echo esc_html($settings['iconbox_title']); ?></span>
							<?php endif; ?>
							<?php if( !empty( $settings['iconbox_sub_title'])): ?>
								<p class="media-info"><?php echo esc_html($settings['iconbox_sub_title']); ?></p>
							<?php endif; ?>
						</div>
					</div>
				</div>

			<?php elseif($settings['icon_box_style'] == '1' || $settings['icon_box_style'] == '2'): ?>
				<div class="counter-style<?php echo esc_attr($settings['icon_box_style']); ?>">
					<?php if( !empty( $settings['iconbox_icon'])): ?>
						<div class="counter-icon">
							<i class="<?php echo esc_attr( $settings['iconbox_icon'] ); ?>"></i>
						</div>
					<?php endif; ?>
					
					<?php if( !empty( $settings['icon_box_image'])): ?>
						<div class="counter-icon">
							<?php
								if( function_exists( 'playrex_img_tag' ) ){
									echo playrex_img_tag([
										'url' => $settings['icon_box_image']['url'],
									]);
								}
							?>
						</div>
					<?php endif; ?>
					
					<div <?php echo  $this->get_render_attribute_string('wrapper') ?> >
						<?php if( !empty( $settings['iconbox_title'])): ?>
							<span class="counter-number">
								<?php echo esc_html($settings['iconbox_title']); ?>
							</span>
						<?php endif; ?>

						<?php if( !empty( $settings['iconbox_sub_title'])): ?>
							<span class="counter-text"><?php echo esc_html($settings['iconbox_sub_title']); ?></span>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>


        <?php
	}
}