<?php

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Icons_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Widget_Base;

class Playrex_List_group extends Widget_Base {

	public function get_name() {
		return 'playrex-list-group';
	}

	public function get_title() {
		return esc_html__( 'List Group', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ol playrex';
	}

	public function get_categories() {
		return [ 'playrex' ];
	}

	public function get_keywords() {
		return [ 'playrex', 'information', 'group', 'list', 'icon', 'socail' ];
	}

	protected function register_controls() {

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'playrex_section_list_content',
			[
				'label' => esc_html__( 'Content', 'playrex' )
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
            'playrex_list_icon_type',
            [
                'label' => __( 'Media Type', 'playrex' ),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'icon',
				'options' => [
					'icon' => [
						'title' => __( 'Icon', 'playrex' ),
						'icon' => 'eicon-star',
					],
					'number' => [
						'title' => __( 'Number', 'playrex' ),
						'icon' => 'eicon-number-field',
					],
					'image' => [
						'title' => __( 'Image', 'playrex' ),
						'icon' => 'eicon-image',
					],
				],
				'toggle' => false,
                'style_transfer' => true,
            ]
        );

		$repeater->add_control(
			'playrex_list_icon',
			[
				'label'       => __( 'Icon', 'playrex' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'separator'   =>'after',
				'default'     => [
					'value'   => 'far fa-check-circle',
					'library' => 'fa-regular'
				],
				'condition' =>[
					'playrex_list_icon_type' => 'icon'
				]
			]
		);

		$repeater->add_control(
			'playrex_list_icon_number',
			[
				'label'   => esc_html__( 'Number', 'playrex' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '1', 'playrex' ),
				'separator'   =>'after',
				'condition' =>[
					'playrex_list_icon_type' => 'number'
				]
			]
		);

		$repeater->add_control(
			'playrex_list_icon_number_image',
			[
				'label' => __( 'Choose Image', 'playrex' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'separator'   =>'after',
				'dynamic' => [
					'active' => true,
				],
				'condition' =>[
					'playrex_list_icon_type' => 'image'
				]
			]
		);

        $repeater->add_control(
			'playrex_list_text',
			[
				'label'   => esc_html__( 'Text', 'playrex' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'List Text', 'playrex' ),
				'dynamic' => [ 'active' => true ]
			]
		);

		$repeater->add_control(
			'playrex_list_link',
			[
				'label' => __( 'List URL', 'playrex' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'playrex' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'playrex_list_group',
			[
				'label' => __( 'List Items', 'elementor' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' => [
					[
						'playrex_list_text' => __( 'List Item #1', 'elementor' ),
						'playrex_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
					[
						'playrex_list_text' => __( 'List Item #2', 'elementor' ),
						'playrex_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
					[
						'playrex_list_text' => __( 'List Item #3', 'elementor' ),
						'playrex_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
				],
				'title_field' => '{{{ elementor.helpers.renderIcon( this, playrex_list_icon, {}, "i", "panel" ) }}}{{{ playrex_list_text }}}'
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'playrex_section_list_style',
			[
				'label' => esc_html__( 'Container', 'playrex' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'playrex_section_list_layout',
			[
				'label' => __( 'Layout', 'playrex' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'layout_1',
				'options' => [
					'layout_1' => __( 'Layout 1', 'playrex' ),
					'layout_2' => __( 'Layout 2', 'playrex' ),
					'layout_3' => __( 'Layout 3', 'playrex' ),
				],
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_alignment',
			[
				'label'       => esc_html__( 'Alignment', 'playrex' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'playrex-list-group-left'   => [
						'title' => esc_html__( 'Left', 'playrex' ),
						'icon'  => 'eicon-text-align-left'
					],
					'playrex-list-group-center' => [
						'title' => esc_html__( 'Center', 'playrex' ),
						'icon'  => 'eicon-text-align-center'
					],
					'playrex-list-group-right'  => [
						'title' => esc_html__( 'Right', 'playrex' ),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'selectors_dictionary' => [
					'playrex-list-group-left' => 'justify-content: flex-start; text-align: left;',
					'playrex-list-group-center' => 'justify-content: center; text-align: center;',
					'playrex-list-group-right' => 'justify-content: flex-end; text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper' => '{{VALUE}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item' => '{{VALUE}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item a' => '{{VALUE}};',
				],
				'default'     => 'playrex-list-group-left',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'playrex_section_list_group_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .playrex-list-group',
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_group_padding',
			[
				'label'      => __( 'Padding', 'playrex' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .playrex-list-group' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'playrex_section_list_group_border',
				'selector'  => '{{WRAPPER}} .playrex-list-group'
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_group_radius',
			[
				'label'        => __( 'Border Radius', 'playrex' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .playrex-list-group' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'playrex_section_list_group_shadow',
				'selector' => '{{WRAPPER}} .playrex-list-group'
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'playrex_section_list_item_style',
			[
				'label' => esc_html__( 'List Item', 'playrex' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_item_padding',
			[
				'label'        => __( 'Item Padding', 'playrex' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'playrex_section_list_item_separator',
            [
				'label'        => __( 'Item Separator', 'playrex' ),
				'type'         =>  Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'playrex' ),
				'label_off'    => __( 'Hide', 'playrex' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'playrex_section_list_layout!' => 'layout_3'
				]
			]
        );

		$this->add_responsive_control(
			'playrex_section_list_item_separator_height',
			[
				'label' => __( 'Separator Height', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_1 .playrex-list-group-item:not(:last-child):after' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_2 .playrex-list-group-item:not(:last-child):after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'playrex_section_list_item_separator' => 'yes',
					'playrex_section_list_layout!' => 'layout_3'
				]
			]
		);

		$this->add_control(
			'playrex_section_list_item_separator_color',
			[
				'label' => __( 'Separator Color', 'playrex' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#e5e5e5',
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_1 .playrex-list-group-item:not(:last-child):after' => 'background: {{VALUE}}',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_2 .playrex-list-group-item:not(:last-child):after' => 'background: {{VALUE}}',
				],
				'condition' => [
					'playrex_section_list_item_separator' => 'yes',
					'playrex_section_list_layout!' => 'layout_3'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_list_item_spacing',
			[
				'label' => __( 'Item Spacing', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_3 .playrex-list-group-item:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'playrex_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'playrex_list_item_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_3 .playrex-list-group-item',
				'condition' => [
					'playrex_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'playrex_list_item_border',
				'selector'  => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_3 .playrex-list-group-item',
				'fields_options'  => [
                    'border' 	  => [
                        'default' => 'solid'
                    ],
                    'width'  	  => [
                        'default' 	 => [
                            'top'    => '1',
                            'right'  => '1',
                            'bottom' => '1',
                            'left'   => '1'
                        ]
                    ],
                    'color' 	  => [
                        'default' => '#e5e5e5',
                    ]
                ],
				'condition' => [
					'playrex_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_list_item_radius',
			[
				'label'        => __( 'Border Radius', 'playrex' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_3 .playrex-list-group-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'playrex_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'playrex_list_item_shadow',
				'selector' => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_3 .playrex-list-group-item',
				'condition' => [
					'playrex_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Icon Style
		*/
		$this->start_controls_section(
			'playrex_section_list_icon_style',
			[
				'label' => esc_html__( 'Icon', 'playrex' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'playrex_list_icon_position',
			[
				'label'       => esc_html__( 'Icon Position', 'playrex' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'playrex-icon-left'   => [
						'title' => esc_html__( 'Left', 'playrex' ),
						'icon'  => 'eicon-h-align-left'
					],
					'playrex-icon-center' => [
						'title' => esc_html__( 'Center', 'playrex' ),
						'icon'  => 'eicon-v-align-top'
					],
					'playrex-icon-right'  => [
						'title' => esc_html__( 'Right', 'playrex' ),
						'icon'  => 'eicon-h-align-right'
					]
				],
				'default'     => 'playrex-icon-left'
			]
		);

		$this->add_responsive_control(
			'playrex_list_icon_alignment',
			[
				'label'       => esc_html__( 'Icon Vertical Alignment', 'playrex' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'playrex-icon-align-left'   => [
						'title' => esc_html__( 'Top', 'playrex' ),
						'icon'  => 'eicon-v-align-top'
					],
					'playrex-icon-align-center' => [
						'title' => esc_html__( 'Center', 'playrex' ),
						'icon'  => 'eicon-v-align-middle'
					],
					'playrex-icon-align-right'  => [
						'title' => esc_html__( 'Bottom', 'playrex' ),
						'icon'  => 'eicon-v-align-bottom'
					]
				],
				'default'     => 'playrex-icon-align-left',
				'selectors_dictionary' => [
					'playrex-icon-align-left' => 'align-items: flex-start;',
					'playrex-icon-align-center' => 'align-items: center;',
					'playrex-icon-align-right' => 'align-items: flex-end;',
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item' => '{{VALUE}};',
				],
				'condition' => [
					'playrex_list_icon_position!' => 'playrex-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_list_icon_top_alignment',
			[
				'label'       => esc_html__( 'Icon Alignment', 'playrex' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'playrex-icon-top-align-left'   => [
						'title' => esc_html__( 'Left', 'playrex' ),
						'icon'  => 'eicon-v-align-top'
					],
					'playrex-icon-top-align-center' => [
						'title' => esc_html__( 'Center', 'playrex' ),
						'icon'  => 'eicon-v-align-middle'
					],
					'playrex-icon-top-align-right'  => [
						'title' => esc_html__( 'Right', 'playrex' ),
						'icon'  => 'eicon-v-align-bottom'
					]
				],
				'default'     => 'playrex-icon-left',
				'selectors_dictionary' => [
					'playrex-icon-top-align-left' => 'text-align: left; margin-right: auto;',
					'playrex-icon-top-align-center' => 'text-align: center; margin-left: auto; margin-right: auto;',
					'playrex-icon-top-align-right' => 'text-align: right; margin-left: auto;',
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon' => '{{VALUE}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon .playrex-list-group-icon-image' => '{{VALUE}};',
				],
				'condition' => [
					'playrex_list_icon_position' => 'playrex-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_item_icon_spacing',
			[
				'label' => __( 'Icon Right Spacing', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-text' => 'padding-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'playrex_list_icon_position' => 'playrex-icon-left'
				]
			]
		);
		$this->add_responsive_control(
			'playrex_section_list_item_icon_left_spacing',
			[
				'label' => __( 'Icon Left Spacing', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'playrex_list_icon_position' => 'playrex-icon-right'
				]
			]
		);
		$this->add_responsive_control(
			'playrex_section_list_item_icon_bottom_spacing',
			[
				'label' => __( 'Icon Bottom Spacing', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'playrex_list_icon_position' => 'playrex-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_item_icon_size',
			[
				'label' => __( 'Icon Size', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon svg' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon .playrex-list-group-icon-image' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'playrex_section_list_item_icon_color',
			[
				'label' => __( 'Icon Color', 'playrex' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'playrex_section_list_item_icon_color_hover',
			[
				'label' => __( 'Icon Color Hover', 'playrex' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon:hover svg path' => 'fill: {{VALUE}}',
				],
			]
		);


		$this->add_responsive_control(
			'playrex_section_list_item_image_radius',
			[
				'label'        => __( 'Image Radius', 'playrex' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon .playrex-list-group-icon-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

		$this->add_control(
			'playrex_list_item_icon_box_enable',
			[
				'label' => __( 'Enable Icon Box', 'playrex' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'playrex' ),
				'label_off' => __( 'Hide', 'playrex' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'playrex_list_item_icon_box_width',
			[
				'label' => __( 'Icon Box Width', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_1 .playrex-list-group-item .playrex-list-group-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_2 .playrex-list-group-item .playrex-list-group-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper.layout_3 .playrex-list-group-item .playrex-list-group-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
				],
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_list_item_icon_box_height',
			[
				'label' => __( 'Icon Box Height', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'playrex_list_item_icon_box_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes',
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'playrex_list_item_icon_box_background_hover',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes:hover',
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'playrex_list_item_icon_box_border',
				'selector'  => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes',
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'playrex_list_item_icon_box_radius',
			[
				'label'        => __( 'Border Radius', 'playrex' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'playrex_list_item_icon_box_shadow',
				'selector' => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-icon.yes',
				'condition' => [
					'playrex_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Text
		*/
		$this->start_controls_section(
			'playrex_section_list_text_style',
			[
				'label' => esc_html__( 'Text', 'playrex' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'playrex_section_list_text_alignment',
			[
				'label'       => esc_html__( 'Text Alignment', 'playrex' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'playrex-text-align-left'   => [
						'title' => esc_html__( 'Left', 'playrex' ),
						'icon'  => 'eicon-text-align-left'
					],
					'playrex-text-align-center' => [
						'title' => esc_html__( 'Center', 'playrex' ),
						'icon'  => 'eicon-text-align-left'
					],
					'playrex-text-align-right'  => [
						'title' => esc_html__( 'Right', 'playrex' ),
						'icon'  => 'eicon-text-align-left'
					]
				],
				'default'     => 'playrex-text-align-left',
				'selectors_dictionary' => [
					'playrex-text-align-left' => 'text-align: left;',
					'playrex-text-align-center' => 'text-align: center;',
					'playrex-text-align-right' => 'text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-text' => '{{VALUE}};',
				],
				'condition' => [
					'playrex_list_icon_position' => 'playrex-icon-center'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'playrex_section_list_text_typography',
				'label' => __( 'Typography', 'playrex' ),
				'selector' => '{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-text',
			]
		);

		$this->add_control(
			'playrex_section_list_text_color',
			[
				'label' => __( 'Text Color', 'playrex' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'playrex_section_list_text_hover_color',
			[
				'label' => __( 'Text Color Hover', 'playrex' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .playrex-list-group .playrex-list-group-wrapper .playrex-list-group-item .playrex-list-group-text:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
		<div class="playrex-list-group">
			<ul class="playrex-list-group-wrapper <?php echo $settings['playrex_section_list_layout']; ?>">
				<?php foreach( $settings['playrex_list_group'] as $list ) : ?>
				<?php
					$target = $list['playrex_list_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $list['playrex_list_link']['nofollow'] ? ' rel="nofollow"' : '';
				?>
					<li class="playrex-list-group-item <?php echo $settings['playrex_list_icon_position']?>">
						<?php if ( !empty( $list['playrex_list_link']['url'] ) ) { ?>
						<a href="<?php echo $list['playrex_list_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> >
						<?php } ?>
							<div class="playrex-list-group-icon <?php echo $settings['playrex_list_item_icon_box_enable']; ?>">
								<?php if ( $list['playrex_list_icon_type'] === 'icon' && !empty($list['playrex_list_icon']) ){ ?>
									<?php Icons_Manager::render_icon( $list['playrex_list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
								<?php } ?>
								<?php if ( $list['playrex_list_icon_type'] === 'number' && !empty($list['playrex_list_icon_type']) ){ ?>
									<div class="playrex-list-group-icon-number">
										<?php echo $list['playrex_list_icon_number']; ?>
									</div>
								<?php } ?>
								<?php if ( $list['playrex_list_icon_type'] === 'image' && !empty($list['playrex_list_icon_type']) ){ ?>
									<div class="playrex-list-group-icon-image">
										<img src="<?php echo $list['playrex_list_icon_number_image']['url'] ?>" alt="<?php echo $list['playrex_list_text']; ?>">
									</div>
								<?php } ?>
							</div>
							<?php if ( !empty( $list['playrex_list_text'] ) ) { ?>
								<span class="playrex-list-group-text">
									<?php echo $list['playrex_list_text']; ?>
								</span>
							<?php } ?>
						<?php if ( !empty( $list['playrex_list_link']['url'] ) ) { ?>
						</a>
						<?php } ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		<?php
	}
}