<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Logo extends Widget_Base {

	public function get_name() {
		return 'playrexprxlogo';
	}

	public function get_title() {
		return __( 'Home 02 Logo', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-logo playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'logo','playrex', 'logo' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_logo',
			[
				'label' 	=> __( 'Logo', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'playrex_logo_image',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->end_controls_section();

    }
	protected function render() {

        $settings = $this->get_settings_for_display();
		

		?> 
            <?php if(!empty( $settings['playrex_logo_image']['url'] )): ?>
                   
                <div class="header-logo2">
                    <a href="<?php site_url(); ?>">
                        <?php 
                            echo playrex_img_tag([
                                'url' => $settings['playrex_logo_image']['url'],
                            ]);
                        ?>
                    </a>
                </div>
            <?php endif; ?>
		<?php
        
	}
}