<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Match extends Widget_Base {

	public function get_name() {
		return 'playrexmatch';
	}

	public function get_title() {
		return __( 'Match', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'match', 'slider', 'game', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_match',
			[
				'label'		 	=> __( 'Match', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'active_slider',
			[
				'label' 		=> __( 'Active Slider', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
        /*  --------------- Repeater Section ---------------*/

        $match_repeater = new Repeater();

        /*  --------------- Top Section ---------------*/

        $match_repeater->add_control(
			'match_style',
			[
				'label' => __('Match Style', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => __('Default', 'playrex'),
					'layout2' => __('Style Two', 'playrex'),
				],
			]
		);


        $match_repeater->add_control(
			'bottom_shape',
			[
				'name'         => 'Bottom Shape',
				'label'        => esc_html__( 'Shape Show/Hide', 'mas-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
                'condition'		=> [ 'match_style' => 'default' ],
			]
        );


        $match_repeater->add_control(
			'match_background',
			[
				'label' 		=> __( 'Match Box Background', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        
        $match_repeater->add_control(
            'top_content',
            [
                'label' => __( 'Top Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );

        $match_repeater->add_control(
			'match_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'gest hits to come out in Pacman', 'playrex' ),
                'label_block'   => true,
			]
        );

        $match_repeater->add_control(
			'team_details',
			[
				'label' 	=> __( 'Details Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        $match_repeater->add_control(
			'match_date',
			[
				'label' 	=> __( 'Time And Date', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'November 25, 2022 4:00 PM', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Top Section ---------------*/

        
        /*  --------------- Left Section ---------------*/
        $match_repeater->add_control(
            'left_content',
            [
                'label' => __( 'Left Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );

        $match_repeater->add_control(
			'team_one_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $match_repeater->add_control(
			'team_one_name',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Rabbits Star', 'playrex' ),
                'label_block'   => true,
			]
        );
        
        $match_repeater->add_control(
			'team_group_membar',
			[
				'label' 	=> __( 'Team Group Image', 'playrex' ),
                'type' 		=> Controls_Manager::MEDIA,
                'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
        $match_repeater->add_control(
			'team_memabr_count',
			[
				'label' 	=> __( 'Total Team Membar', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '+5', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Left Section ---------------*/

        /*  --------------- Middle Section ---------------*/
        $match_repeater->add_control(
            'middle_content',
            [
                'label' => __( 'Middle Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );
        $match_repeater->add_control(
			'match_time',
			[
				'label' 	=> __( 'Match Time Duration', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '02:02', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Middle Section ---------------*/

        /*  --------------- Right Section ---------------*/
        $match_repeater->add_control(
            'right_content',
            [
                'label' => __( 'Right Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );
        $match_repeater->add_control(
			'team_two_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $match_repeater->add_control(
			'team_two_name',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Wizard Wer', 'playrex' ),
                'label_block'   => true,
			]
        );
        $match_repeater->add_control(
			'team_two_group_membar',
			[
				'label' 	=> __( 'Team Group Image', 'playrex' ),
                'type' 		=> Controls_Manager::MEDIA,
                'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
        $match_repeater->add_control(
			'team_two_memabr_count',
			[
				'label' 	=> __( 'Total Team Membar', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '+5', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Right Section ---------------*/

        /*  --------------- Bottom Section ---------------*/
        $match_repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Watch Stream', 'playrex' ),
                'label_block'   => true,
			]
        );

        $match_repeater->add_control(
			'button_url',
			[
				'label' 	=> __( 'Button Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        /*  --------------- End Bottom Section ---------------*/

        $this->add_control(
			'match_repeater',
			[
				'label' 		=> __( 'Match', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $match_repeater->get_controls(),
				'default' 		=> [
					[
						'match_title'        => __( 'biggest hits to come out in Pacman', 'playrex' ),
						'match_date'         => __( 'November 25, 2022 4:00 PM', 'playrex' ),
                        'team_one_thumb' 	 => Utils::get_placeholder_image_src(),
                        'team_one_name'      => __( 'Rabbits Star', 'playrex' ),
                        'team_group_membar'  => Utils::get_placeholder_image_src(),
                        'team_memabr_count'  => __( '5+', 'playrex' ),
                        'match_time'         => __( '02:02', 'playrex' ),
                        'button_text'        => __( 'Watch Stream', 'playrex' ),
                        'button_url'         => __( 'https://www.youtube.com/watch?v=_sI_Ps7JSEk', 'playrex' ),
                        'team_two_thumb'  => Utils::get_placeholder_image_src(),
                        'team_two_name'    => __( 'Wizard Wer', 'playrex' ),
                        'team_two_group_membar' => Utils::get_placeholder_image_src(),
                        'team_two_memabr_count'  => __( '5+', 'playrex' ),

					],
				],
				'title_field' 	=> '{{{ match_date }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/

        /*  --------------- Slider Settings ---------------*/
        $this->end_controls_section();

        $this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'playrex' ),
				'type' 			=> Controls_Manager::NUMBER,
				'default'      => '1',
			]
		);
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_dots',
			[
				'label' 		=> __( 'Dots', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'AutoPlay', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Slider Settings ---------------*/


        /*  --------------- Box Style Section ---------------*/
        $this->start_controls_section(
			'match_box_style',
			[
				'label'		 	=> __( 'Match Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs( 'box_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'box_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'box_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-style2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-style2',
            ]
		);
        $this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-style2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->add_responsive_control(
			'box_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-style2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-style2' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_tab();

        /*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'box_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
        $this->add_control(
            'box_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-style2:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border_hover',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-style2:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Box Style Section ---------------*/


        /*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Match Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-name',
			]
		);


        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

        /*  --------------- Date Style ---------------*/
        $this->start_controls_section(
			'heading_date',
			[
				'label'		 	=> __( 'Match Date', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'date_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-date' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'date_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-date',
			]
		);


        $this->add_responsive_control(
			'date_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Date Style ---------------*/


        /*  --------------- Team Thumnail Style ---------------*/
        $this->start_controls_section(
			'heading_team_logo',
			[
				'label'		 	=> __( 'Team Logo', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
			'team_logo_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Team Style ---------------*/

        /*  --------------- Team Style ---------------*/
        $this->start_controls_section(
			'heading_team_name',
			[
				'label'		 	=> __( 'Team Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'team_name_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'team_name_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .team-name',
			]
		);

        $this->add_responsive_control(
			'team_name_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Team Style ---------------*/

        /*  --------------- Time Style ---------------*/
        $this->start_controls_section(
			'heading_time',
			[
				'label'		 	=> __( 'Match Time', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'time_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-time' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'time_bg_color',
            [
                'label'     => __('Box Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-time' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'time_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-time',
			]
		);

        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'time_shadow',
				'label' => __('Icon Shadow', 'playrex'),
				'selector' => '{{WRAPPER}} .match-time',
			]
		);

        $this->add_responsive_control(
			'time_box_height',
			[
				'label' => __( 'Time Box Height', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} .match-time' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'time_border-radius',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-time' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'time_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();
        /*  --------------- End Time Style ---------------*/

        /*  ---------------  Arrow Style ---------------*/
        $this->start_controls_section(
			'arrow_style',
			[
				'label'		 	=> __( 'Arrow', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'arrow_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'arrow_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'arrow_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-arrow',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'arrow_Hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
        $this->add_control(
            'arrow_hover_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-arrow:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  ---------------  Arrow Style End ---------------*/

        /*  ---------------  Dots Style ---------------*/
        $this->start_controls_section(
			'dots_style',
			[
				'label'		 	=> __( 'Dots', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'dots_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'dots_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'dots_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-dots button' => 'Background color: {{VALUE}}',
                ],
            ]
        );

       

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-dots button',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'dots_Hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
        $this->add_control(
            'dots_bg_color_active',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-dots button, {{WRAPPER}} .match-custom .slick-dots .slick-active button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'dots_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-dots button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-dots button:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  ---------------  Dots Style End ---------------*/


        /*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'button_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
			'button_type',
			[
				'label' => __('Icon type', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
                'default' => 'default',
				'options' => [
					'default'  => __('Inline Button', 'playrex'),
					'fullwidth-button' => __('Full Width', 'playrex'),
				],
			]
		);

        $this->add_control(
            'button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-bottom .vs-btn',
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-bottom .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-bottom .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $match_repeater = $settings['match_repeater'];
        $button_type = $settings['button_type'];

        if( 'yes' == $settings['active_slider'] ){

            $this->add_render_attribute( 'wrapper', 'class', $button_type );
            $this->add_render_attribute( 'wrapper', 'class', 'match-custom' );

            if($settings['slider_arrows'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-arrows',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-arrows',  'false' );
            }
            if($settings['slider_dots'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-dots',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-dots',  'false' );
            }
            if($settings['slider_autoplay'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'false' );
            }


            $this->add_render_attribute( 'wrapper', 'data-slide-to-show',  1);
            
        }else{
            $this->add_render_attribute( 'wrapper', 'class', $button_type );
        }

        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <?php foreach( $match_repeater as $mr): ?>
                <div>
                    <div class="match-style2 <?php echo esc_attr($mr['match_style'] ); ?>" data-bg-src="<?php echo esc_url($mr['match_background']['url']); ?>">
                        <?php if($mr['match_title']): ?>
                            <h3 class="match-name">
                                <a href="<?php echo esc_url($mr['team_details']); ?>" class="text-inherit">
                                    <?php echo esc_html($mr['match_title']); ?>
                                </a>
                            </h3>
                        <?php endif; ?>

                        <?php if($mr['match_date'] && $mr['match_style'] == 'default'): ?>
                            <p class="match-date"><?php echo esc_html($mr['match_date']); ?></p>
                        <?php endif; ?>


                        <div class="match-body">
                            <div class="match-team">
                                <?php if( $mr['team_one_thumb']['url'] ): ?>
                                    <div class="team-logo">
                                        <a href="<?php echo esc_url($mr['team_details']); ?>">
                                            <?php
												if( function_exists( 'playrex_img_tag' ) ){
													echo playrex_img_tag(array(
														'url'	=> esc_url( $mr['team_one_thumb']['url'] )
													));
												}
											?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="media-body">
                                    <?php if($mr['team_one_name']): ?>
                                        <h4 class="team-name h6">
                                            <a href="<?php echo esc_url($mr['team_details']); ?>" class="text-inherit">
                                                <?php echo esc_html($mr['team_one_name']); ?>
                                            </a>
                                        </h4>
                                    <?php endif; ?>
                                    <?php if( $mr['team_group_membar']['url'] ): ?>
                                        <div class="team-avaters">
                                            <?php
												if( function_exists( 'playrex_img_tag' ) ){
													echo playrex_img_tag(array(
														'url' 	=> esc_url( $mr['team_group_membar']['url'] )
													) );
												}
											?>
                                            <span class="total-avater">
                                                <?php echo esc_html($mr['team_memabr_count']); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="match-middle">
                                <?php if($mr['match_time']): ?>
                                    <div class="match-time">
                                        <?php echo esc_html($mr['match_time']); ?>
                                    </div>
                                <?php endif; ?>
                                

                                <?php if($mr['match_date'] && $mr['match_style'] == 'layout2'): ?>
                                    <p class="match-date"><?php echo esc_html($mr['match_date']); ?></p>
                                <?php endif; ?>
                            </div>

                            <div class="match-team">
                                <?php if( $mr['team_two_thumb']['url'] ): ?>
                                    <div class="team-logo">
                                        <a href="<?php echo esc_url($mr['team_details']); ?>">
											<?php
												if( function_exists( 'playrex_img_tag' ) ){
													echo playrex_img_tag(array(
														'url' 	=> esc_url( $mr['team_two_thumb']['url'] )
													) );
												}
											?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="media-body">
                                    <?php if($mr['team_two_name']): ?>
                                        <h4 class="team-name h6">
                                            <a href="<?php echo esc_url($mr['team_details']); ?>" class="text-inherit">
                                                <?php echo esc_html($mr['team_two_name']); ?>
                                            </a>
                                        </h4>
                                    <?php endif; ?>
                                    
                                    <?php if( $mr['team_two_group_membar']['url'] ): ?>
                                        <div class="team-avaters">
											<?php
												if( function_exists( 'playrex_img_tag' ) ){
													echo playrex_img_tag(array(
														'url' 	=> esc_url( $mr['team_two_group_membar']['url'] )
													) );
												}
											?>
                                            <span class="total-avater">
                                                <?php echo esc_html( $mr['team_two_memabr_count'] ); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php if( $mr['button_text'] ): ?>
                            <div class="match-bottom">
                                <a href="<?php echo esc_url( $mr['button_url'] ); ?>" class="vs-btn popup-video">
                                <i class="fab fa-twitch"></i>
                                   <?php echo esc_html( $mr['button_text'] ); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if( 'yes'==  $mr['bottom_shape'] ): ?>
                            <div class="match-shape1"></div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php
	}
}