<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Player_Card extends Widget_Base {

	public function get_name() {
		return 'playrexplayer_card';
	}

	public function get_title() {
		return __( 'Team Membar', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'player', 'team', 'game', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_player',
			[
				'label'		 	=> __( 'Player', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'image_style',
			[
				'label' => esc_html__( 'Team Style', 'playrex' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'player-style1',
				'options' => [
					'player-style1' => esc_html__( 'Style One', 'playrex' ),
					'player-style2' => esc_html__( 'Style Two', 'playrex' ),
				],
			]
		);

        $this->add_control(
			'image_position',
			[
				'label' => esc_html__( 'Image Position', 'playrex' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'default', 'playrex' ),
					'revearse' => esc_html__( 'Revearse', 'playrex' ),
				],
                'condition' => [
                    'image_style' => 'player-style1'
                ],
			]
		);

        $this->add_control(
			'player_img',
			[
				'label' 		=> __( 'Player Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'player_single_page',
			[
				'label' 	=> __( 'Single Page Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '#', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'player_title',
			[
				'label' 	=> __( 'Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Adriana Lola', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'player-degi',
			[
				'label' 	=> __( 'Player Designation', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Adriana Lola', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			'player_email',
			[
				'label' 	=> __( 'Email', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'member@ninjawarrior.com', 'playrex' ),
                'label_block'   => true,
			]
        );
        $player_socail_link = new Repeater();
        
        $player_socail_link->add_control(
			'player_socail_icon',
			[
				'label' 	=> __( 'Icon Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '', 'playrex' ),
                'label_block'   => true,
			]
        );

        $player_socail_link->add_control(
			'button_url',
			[
				'label' => __('URL', 'mas-addons'),
				'type' =>  Controls_Manager::URL,
			]
		);

        $this->add_control(
			'profile_repeater',
			[
				'label' 		=> __( 'Social Profile', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $player_socail_link->get_controls(),
				'default' 		=> [
					[
						'player_socail_icon'        => __( 'fab fa-facebook-f', 'playrex' ),
						'button_url'         => __( '#', 'playrex' ),

					],
					[
						'player_socail_icon'        => __( 'fab fa-twitter', 'playrex' ),
						'button_url'         => __( '#', 'playrex' ),

					],
					[
						'player_socail_icon'        => __( 'fab fa-instagram', 'playrex' ),
						'button_url'         => __( '#', 'playrex' ),

					]
				],
				'title_field' 	=> '{{{ player_socail_icon }}}',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Ripitar Section ---------------*/

        /*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-name .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .player-name',
			]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .player-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/


        /*  --------------- Degi Style ---------------*/
        $this->start_controls_section(
			'degi_title',
			[
				'label'		 	=> __( 'Designation', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'degi_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-degi' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'degi_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .player-degi',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Degi Style ---------------*/


        /*  --------------- Player Style ---------------*/
        $this->start_controls_section(
			'player_mail',
			[
				'label'		 	=> __( 'Email', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'player_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-mail' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'player_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-name .player-mail:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'player_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .player-mail',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Player Style ---------------*/


        /*  --------------- Socail Link Style ---------------*/
        $this->start_controls_section(
			'plyaer_socail_link',
			[
				'label'		 	=> __( 'Socail Profile', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->start_controls_tabs( 'plyaer_socail_tab_normal' );

		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'plyaer_socail_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);

        $this->add_control(
            'plyaer_socail_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-social a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'plyaer_socail_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-social a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'plyaer_socail_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .player-social a',
			]
		);
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'socail_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .player-social a',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'plyaer_socail_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);

        $this->add_control(
            'plyaer_socail_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-social a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'plyaer_socail_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-social a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'socail_border_hover',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .player-social a:hover',
            ]
		);
        $this->end_controls_section();
        $this->end_controls_tab();
        $this->end_controls_tabs();
        /*  --------------- Socail Link Style ---------------*/
        $this->start_controls_section(
			'plyaer_box',
			[
				'label'		 	=> __( 'Wraper', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'plyaer_box_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-body' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'plyaer_box_bg_sahpe_color',
            [
                'label'     => __('Shape Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-shape1' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'plyaer_box_bg_color_hover',
            [
                'label'     => __('Background Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .player-style1:hover .player-bg' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'plyaer_box_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .player-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->add_responsive_control(
			'plyaer_box_paddings',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .player-body' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();

        /*  --------------- Wraper Box Style ---------------*/
        
	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $image_position = $settings['image_position'];
        $image_style = $settings['image_style'];

        if('player-style1' == $image_style){
            $this->add_render_attribute( 'version', 'class', ['player-style1', $image_position ] );
        }else{
            $this->add_render_attribute( 'version', 'class', ['player-style1', 'layout2' ] );
        };

        ?>
        <div <?php echo  $this->get_render_attribute_string('version'); ?> >
            <div class="player-body">
                <div class="player-bg"></div>
                <div class="player-img">

                    <?php if( 'player-style1' == $image_style): ?>
                        <div class="player-shape1"></div>
                    <?php endif; ?>

                    <?php if(!empty($settings['player_img']['url'])): ?>
                        <?php  echo playrex_img_tag([
                            'url' => $settings['player_img']['url'],
                        ]);
                        ?>
                    <?php endif; ?>
                </div>

                <div class="player-content">
                    <?php if(!empty($settings['player_title'])): ?>
                        <h3 class="player-name">
                            <a class="text-inherit" href="<?php echo esc_url($settings['player_single_page']); ?>">
                                <?php echo esc_html($settings['player_title']); ?>
                            </a>
                        </h3>
                    <?php endif; ?>

                    <?php if(!empty($settings['player-degi'])): ?>
                        <p class="player-degi">
                            <?php echo esc_html($settings['player-degi']); ?>
                        </p>
                    <?php endif; ?>
                    
                    <?php if(!empty($settings['player_email'])): ?>
                        <a href="mailto:<?php echo esc_url($settings['player_email']); ?>" class="player-mail"><i
                                class="fas fa-envelope"></i>
                                <?php echo esc_html($settings['player_email']); ?>
                        </a>
                    <?php endif; ?>

                    <?php if($settings['profile_repeater']): ?>
                        <div class="player-social">
                            <?php foreach( $settings['profile_repeater'] as $profile ):
                                $url      = $profile['button_url']['url'];
                                
                                ?>
                                <a href="<?php echo esc_url( $url ) ?>"><i class="<?php echo esc_attr( $profile['player_socail_icon'] ) ?>"></i></a>

                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    
                </div>
            </div>
        </div>
        <?php
	}
}