<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Player_Tab extends Widget_Base {

	public function get_name() {
		return 'playrexplayer';
	}

	public function get_title() {
		return __( 'Player Match', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-hypster playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'player', 'team', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_player',
			[
				'label'		 	=> __( 'Player Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        /*  --------------- Repeater Section ---------------*/
        $player_repeater = new Repeater();

		$player_repeater->add_control(
			'team_nmae',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        $player_repeater->add_control(
			'player_image',
			[
				'label' 	=> __( 'Image', 'playrex' ),
                'type' 		=> Controls_Manager::MEDIA,
                'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
		
        $player_repeater->add_control(
			'playrex_player_builder',
			[
				'label'     => __( 'Select Content', 'playrex' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->playrex_tab_build(),
				'default'	=> ''
			]
		);
        $this->add_control(
			'player_repeater',
			[
				'label' 		=> __( 'Player Box', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $player_repeater->get_controls(),
				'default' 		=> [
					[
						'player_image'  => Utils::get_placeholder_image_src(),
						'team_nmae'  => __( 'Rabbits Star', 'playrex' ),
					],
					[
						'player_image'  => Utils::get_placeholder_image_src(),
						'team_nmae'  => __( 'Bunny Hood II', 'playrex' ),
					],
					[
						'player_image'  => Utils::get_placeholder_image_src(),
						'team_nmae'  => __( 'Area Cup Plus', 'playrex' ),
					],
					[
						'player_image'  => Utils::get_placeholder_image_src(),
						'team_nmae'  => __( 'Daotsu Counter', 'playrex' ),
					],
					[
						'player_image'  => Utils::get_placeholder_image_src(),
						'team_nmae'  => __( 'Santa Paws', 'playrex' ),
					],
					[
						'player_image'  => Utils::get_placeholder_image_src(),
						'team_nmae'  => __( 'Asia Pacific', 'playrex' ),
					],
				],
				'title_field' 	=> '{{{ team_nmae }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/
        $this->end_controls_section();

		 /*  --------------- Title Style ---------------*/
		 $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Match Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_background_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-name' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-name',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/



		/*  --------------- Box Style Section ---------------*/
        $this->start_controls_section(
			'match_box_style',
			[
				'label'		 	=> __( 'Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs( 'box_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'box_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);


        $this->add_control(
            'box_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}   .tab-btn',
            ]
		);

		
        $this->add_responsive_control(
			'box_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .tab-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .tab-btn' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_tab();

        /*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'box_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
        $this->add_control(
            'box_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'box_border_hover',
            [
                'label'     => __('Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .team-nav1 .slick-current .tab-btn, {{WRAPPER}} .team-nav1 .tab-btn:hover' => 'border-color: {{VALUE}}'
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Box Style Section ---------------*/


	}


    public function playrex_tab_build(){

		$playrex_post_query = new WP_Query( array(
			'post_type'				=> 'playrex_tab_build',
			'posts_per_page'	    => -1,
		) );

		$playrex_tab_builder_title_title = array();
		$playrex_tab_builder_title_title[''] = __( 'Select a Title', 'playrex' );

		while( $playrex_post_query->have_posts() ) {
			$playrex_post_query->the_post();
			$playrex_tab_builder_title_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();
		return $playrex_tab_builder_title_title;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		$player_repeaters = $settings['player_repeater'];

        ?>
            <!-- Tab Nav Bar data -->
            <div class="row team-nav1" id="teamnav">
                <?php foreach($player_repeaters as $player_repeater): ?>
                    <div class="col-xl-3">
                        <div class="tab-btn">
							<?php if(!empty($player_repeater['team_nmae'])): ?>
								<span class="team-name">
									<?php echo esc_html( $player_repeater['team_nmae'] ); ?>
								</span>
							<?php endif; ?>
                            <?php
								if( function_exists( 'playrex_img_tag' ) ){
	                                echo playrex_img_tag([
	                                    'url' 	=> $player_repeater['player_image']['url'],
										'class' => 'team-logo',
	                                ]);
								}
                            ?>
                            <span class="btn-border"></span>
                            <span class="btn-border"></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="content-slide" id="palyergroup1">
                    
                <?php foreach( $player_repeaters as $player_repeater ): ?>
					<div>
						<?php if( ! empty($player_repeater['playrex_player_builder'] ) ): ?>
							<?php
								$elementor = \Elementor\Plugin::instance();
								echo $elementor->frontend->get_builder_content_for_display( $player_repeater['playrex_player_builder'] );
							?>
						<?php endif;?>
					</div>
                <?php endforeach; ?>
            </div>
	    <?php
	}
}