<?php


use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Pricing Box Widget .
 *
 */
class Playrex_Pricing_Box extends Widget_Base {

	public function get_name() {
		return 'playrexpricingbox';
	}

	public function get_title() {
		return __( 'Pricing Box', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-price-list playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'pricing box', 'pricing', 'playrex' ];
	}


	protected function register_controls() {

        /*  ---------------  Section ---------------*/
		$this->start_controls_section(
			'pricing_table_section',
			[
				'label' 	=> __( 'Pricing Box', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        /*  --------------- Repeater Section ---------------*/
		$pricing_repeater = new Repeater();

        $pricing_repeater->add_control(
			'package_active',
			[
				'name'         => 'Active Plane',
				'label'        => esc_html__( 'Item Active?', 'playrex' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes'
			]
        );

        $pricing_repeater->add_control(
			'package_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'DUOS', 'playrex' ),
                'label_block' => true,
			]
        );

        $pricing_repeater->add_control(
			'price_currency',
			[
				'label' 	=> __( 'Price Currency', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '$', 'playrex' ),
                'label_block' => true,
			]
        );

        $pricing_repeater->add_control(
			'package_price',
			[
				'label' 	=> __( 'Package Price', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '30.10', 'playrex' ),
                'label_block' => true,
			]
        );

        $pricing_repeater->add_control(
			'package_sub_title',
			[
				'label' 	=> __( 'Sub Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '- Per session', 'playrex' ),
                'label_block' => true,
			]
        );

        $pricing_repeater->add_control(
			'package_list',
			[
				'label' 	=> __( 'Pricing table list item', 'playrex' ),
                'type' 		=> Controls_Manager::WYSIWYG,
                'default'  	=> __( '- Per session', 'playrex' )
			]
        );

        $pricing_repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Book Now', 'playrex' ),
                'label_block' => true,
			]
        );

        $pricing_repeater->add_control(
			'button_link',
			[
				'label' 		=> __( 'Button Url', 'playrex' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'playrex' ),
                'label_block' => true,
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'pricing_list',
			[
				'label' 		=> __( 'Pricing Box', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $pricing_repeater->get_controls(),
				'default' 		=> [
					[
						'package_title'         => __( 'DUOS', 'playrex' ),
						'price_currency'        => __( '$', 'playrex' ),
						'package_price'         => __( '30.10', 'playrex' ),
						'package_sub_title'     => __( '- Per session', 'playrex' ),
						'package_list'          => __( 'Free Gear', 'playrex' ),
						'button_text'            => __( 'Book Now', 'playrex' ),
                        'package_active'        => 'no',
					],
					[
						'package_title'         => __( 'TRIOS', 'playrex' ),
						'price_currency'        => __( '$', 'playrex' ),
						'package_price'         => __( '50.10', 'playrex' ),
						'package_sub_title'     => __( '- Per session', 'playrex' ),
						'package_list'     => __( 'Free Gear', 'playrex' ),
                        'button_text'            => __( 'Book Now', 'playrex' ),
                        'package_active'        => 'yes',
					],
					[
						'package_title'         => __( 'QUADS', 'playrex' ),
						'price_currency'        => __( '$', 'playrex' ),
						'package_price'         => __( '80.10', 'playrex' ),
						'package_sub_title'     => __( '- Per session', 'playrex' ),
						'package_list'     => __( 'Free Gear', 'playrex' ),
                        'button_text'            => __( 'Book Now', 'playrex' ),
                        'package_active'        => 'no',
					],
				],
				'title_field' 	=> '{{{ package_title }}}',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Repeater Section ---------------*/




        /*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'plane_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .package-name',
			]
		);


        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/


        /*  --------------- Currency Style ---------------*/
        $this->start_controls_section(
			'currency_style',
			[
				'label'		 	=> __( 'Currency', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'currency_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .currency' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'currency_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .currency',
			]
		);
        $this->add_responsive_control(
			'currency_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .currency' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Currency Style ---------------*/

        /*  --------------- Price Style ---------------*/
        $this->start_controls_section(
			'price_style',
			[
				'label'		 	=> __( 'Price', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'price_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-price' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'price_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .package-price',
			]
		);
        $this->add_responsive_control(
			'price_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Currency Style ---------------*/

		/*  --------------- Subtitle Style ---------------*/
		 $this->start_controls_section(
			'subtitle_style',
			[
				'label'		 	=> __( 'Sub Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-duration' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'subtitle_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .package-duration',
			]
		);
        $this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-duration' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Subtitle Style ---------------*/


		/*  --------------- Featurelist Style ---------------*/
		 $this->start_controls_section(
			'featurelist_style',
			[
				'label'		 	=> __( 'Feature List', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'featurelist_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'featurelist_border_color',
            [
                'label'     => __('Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-list li' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'featurelist_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .package-list li',
			]
		);
        $this->add_responsive_control(
			'featurelist_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'featurelist_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Subtitle Style ---------------*/


		/*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'button_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'button_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
		$this->add_control(
            'button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

        /*  --------------- Box Style ---------------*/
		 $this->start_controls_section(
			'box_style',
			[
				'label'		 	=> __( 'Pricing Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'box_active_color',
            [
                'label'     => __('Active Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style1.active .package-shape, {{WRAPPER}} .package-style1.active .package-top, {{WRAPPER}} .package-style1:hover .package-shape, {{WRAPPER}} .package-style1:hover .package-top' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'box_active_border_color',
            [
                'label'     => __('Active Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style1.active, {{WRAPPER}} .package-style1:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        /*  --------------- End Box Style ---------------*/
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $pricing_lists = $settings['pricing_list'];

        ?>
            <svg class="svg-hidden">
                <clipPath id="priceoneclip" clipPathUnits="objectBoundingBox">
                    <path d="M1,1 L0.755,0.798 L0.806,0.494 L0,0 L0.999,0"></path>
                </clipPath>
            </svg>
            <div class="row gx-60 justify-content-center">
                <?php foreach( $pricing_lists as $list ):
                    $active = '';
	                    if( 'yes' == $list['package_active'] ){
	                        $active  = 'active';
	                    }else{
	                        $active  = '';
	                    }
                    ?>
                    <!-- package_active -->
                    <div class="col-md-6 col-lg-4 package-zigzag">
                        <div class="package-style1 <?php echo esc_attr($active); ?>">
                            <div class="package-top">
                                <div class="package-shape"></div>
                                <?php if( ! empty($list['package_title'] ) ): ?>
                                    <h3 class="package-name">
                                    <?php echo esc_html( $list['package_title'] ); ?>
                                </h3>
                                <?php endif; ?>
                                <?php if( ! empty($list['price_currency'] ) ): ?>
                                    <div class="package-price">
                                        <span class="currency"><?php echo esc_html( $list['price_currency'] ); ?></span>
                                        <?php echo esc_html( $list['package_price'] ); ?>
                                </div>
                                <?php endif; ?>
                                <?php if(!empty($list['package_sub_title'])): ?>
                                    <span class="package-duration">
                                        <?php echo esc_html($list['package_sub_title']); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <?php if(!empty($list['package_list'])): ?>
                                <div class="package-list">
                                    <?php echo wp_kses_post($list['package_list']); ?>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($list['button_text'])): ?>
                                <a href="<?php echo esc_url($list['button_link']['url']) ?>" class="vs-btn">
                                    <?php echo esc_html($list['button_text']); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php
	}
}