<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Process Widget .
 *
 */
class Playrex_Process extends Widget_Base {

	public function get_name() {
		return 'playrexprocess';
	}

	public function get_title() {
		return __( 'Process', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-parallax playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'process', 'feature', 'box', 'icobox' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_process',
			[
				'label'		 	=> __( 'Process', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        /*  --------------- Repeater Section ---------------*/
        $process_repeater = new Repeater();

        $process_repeater->add_control(
			'process_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'New Tournaments Every Day', 'playrex' ),
                'dynamic'   => ['active' => true ],
			]
        );
        $process_repeater->add_control(
			'process_number',
			[
				'label' 	=> __( 'Number', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'New Tournaments Every Day', 'playrex' ),
                'dynamic'   => ['active' => true ],
			]
        );
        $process_repeater->add_control(
			'thumb_image',
			[
				'label' 		=> __( 'Thumbnail Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> ['active' => true ],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $process_repeater->add_control(
			'icon_image',
			[
				'label' 		=> __( 'Small Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> ['active' => true ],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        
        $this->add_control(
			'process_repeater',
			[
				'label' 		=> __( 'Process', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $process_repeater->get_controls(),
				'default' 		=> [
					[
                        'thumb_image'      => Utils::get_placeholder_image_src(),
                        'icon_image'       => Utils::get_placeholder_image_src(),
						'process_title'    => __( '01.', 'playrex' ),
						'process_number'   => __( 'New Tournaments Every Day', 'playrex' ),
					],
					[
                        'thumb_image'      => Utils::get_placeholder_image_src(),
                        'icon_image'       => Utils::get_placeholder_image_src(),
						'process_title'    => __( '02.', 'playrex' ),
						'process_number'   => __( 'CHALLENGE YOUR ONLINE FRIENDS', 'playrex' ),
					],
					[
                        'thumb_image'      => Utils::get_placeholder_image_src(),
                        'icon_image'       => Utils::get_placeholder_image_src(),
						'process_title'    => __( '03.', 'playrex' ),
						'process_number'   => __( 'STARTS AVAILABLE ONLINE GAMES', 'playrex' ),
					],
				],
				'title_field' 	=> '{{{ process_number }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/
        $this->end_controls_section();



		/*  --------------- Numabr Style ---------------*/
        $this->start_controls_section(
			'heading_numbar',
			[
				'label'		 	=> __( 'numbar', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'numbar_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-style1 .process-number' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'numbar_color_border',
            [
                'label'     => __('Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-style1 .process-number' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'numbar_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .process-style1 .process-number',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

        /*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-style1 .process-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .process-style1 .process-title',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/


        /*  --------------- Box Style ---------------*/
        $this->start_controls_section(
			'proses_style',
			[
				'label'		 	=> __( 'Content Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'content_box_bg_color',
            [
                'label'     => __('Background', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-style1 .process-body' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}
    

	protected function render() {
        $settings = $this->get_settings_for_display();
        $process_repeater = $settings['process_repeater'];
        ?>
            <div class="row gx-xl-0">
                <?php foreach($process_repeater as $pr): ?>
                <div class="col-md-6 col-lg-4 process-style1">
                    <div class="process-body">
                        <div class="process-top">

                            <?php if($pr['thumb_image']['url'] ): ?>
                                <div class="process-img">
                                    <?php
										echo playrex_img_tag(array(
											'url'	=> esc_url( $pr['thumb_image']['url'] )
										));
									?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($pr['icon_image']['url']): ?>
                                <div class="process-icon">
                                    <?php
										echo playrex_img_tag(array(
											'url'	=> esc_url( $pr['icon_image']['url'] )
										));
									?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="process-content">
                            <?php if($pr['process_title']): ?>
                                <span class="process-number">
                                    <?php echo esc_html($pr['process_title']); ?>
                                </span>
                            <?php endif; ?>
                            
                            <?php if($pr['process_number']): ?>
                                <h3 class="process-title">
                                    <?php echo esc_html($pr['process_number']); ?>
                                </h3>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php
	}
}