<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Team extends Widget_Base {

	public function get_name() {
		return 'playrexteam';
	}

	public function get_title() {
		return __( 'Team', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-person playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'team', 'slider', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_team',
			[
				'label'		 	=> __( 'Team', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'active_slider',
			[
				'label' 		=> __( 'Active Slider', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->add_control(
            'team_style',
            [
                'label' => __( 'Select Style', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 'style-one',
                'options'            => [
                    'style-one' => 'Style One',
                    'style-two' => 'Style Two',
                    'style-three' => 'Style Three',
                ],
            ]
        );
        /*  --------------- Repeater Section ---------------*/

        $team_repeater = new Repeater();

        /*  --------------- Top Section ---------------*/

      

        $team_repeater->add_control(
			'team_details',
			[
				'label' 	=> __( 'Details Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        /*  --------------- Right Section ---------------*/
        $team_repeater->add_control(
			'team_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $team_repeater->add_control(
			'team_name',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Wizard Wer', 'playrex' ),
                'label_block'   => true,
			]
        );
        $team_repeater->add_control(
			'team_group_membar',
			[
				'label' 	=> __( 'Team Group Image', 'playrex' ),
                'type' 		=> Controls_Manager::MEDIA,
                'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
        $team_repeater->add_control(
			'team_memabr_count',
			[
				'label' 	=> __( 'Total Team Membar', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '+5', 'playrex' ),
                'label_block'   => true,
			]
        );

        $team_repeater->add_control(
			'team_team_wins',
			[
				'label' 	=> __( 'Wins', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );
        $team_repeater->add_control(
			'team_team_loses',
			[
				'label' 	=> __( 'Loses', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );
        $team_repeater->add_control(
			'team_team_draws',
			[
				'label' 	=> __( 'Draws', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );

        /*  --------------- Bottom Section ---------------*/
        $team_repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'more Information', 'playrex' ),
                'label_block'   => true,
			]
        );

        $team_repeater->add_control(
			'button_url',
			[
				'label' 	=> __( 'Button Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        /*  --------------- End Bottom Section ---------------*/

        $this->add_control(
			'team_repeater',
			[
				'label' 		=> __( 'Team', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $team_repeater->get_controls(),
				'default' 		=> [
					[
                        'team_thumb'  => Utils::get_placeholder_image_src(),
                        'team_name'    => __( 'Wizard Wer', 'playrex' ),
                        'team_group_membar' => Utils::get_placeholder_image_src(),
                        'team_memabr_count'  => __( '5+', 'playrex' ),
                        'team_team_wins'  => __( '45', 'playrex' ),
                        'team_team_loses'  => __( '11', 'playrex' ),
                        'team_team_draws'  => __( '08', 'playrex' ),
                        'button_text'        => __( 'more Information', 'playrex' ),
                        'button_url'         => __( '#', 'playrex' ),

					],
				],
				'title_field' 	=> '{{{ team_name }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/

        /*  --------------- Slider Settings ---------------*/
        $this->end_controls_section();

        $this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->add_control(
            'slide_show_item',
            [
                'label' => __( 'Slider Items', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
            ]
        );
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_dots',
			[
				'label' 		=> __( 'Dots', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'AutoPlay', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Slider Settings ---------------*/


        /*  --------------- Box Style Section ---------------*/
        $this->start_controls_section(
			'team_box_style',
			[
				'label'		 	=> __( 'Team Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs( 'box_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'box_tab_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);
        $this->add_control(
            'box_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style1 .team-body' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .team-style1 .team-body',
            ]
		);
        $this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->add_responsive_control(
			'box_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-body' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_tab();

        /*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'box_tab_hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
        $this->add_control(
            'box_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style1 .team-body:hover, {{WRAPPER}} .slick-current.team-style1 .team-body' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Box Style Section ---------------*/


        

        

        /*  --------------- Team Thumnail Style ---------------*/
        $this->start_controls_section(
			'heading_team_logo',
			[
				'label'		 	=> __( 'Team Logo', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
			'team_logo_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Team Style ---------------*/

        /*  --------------- Team Style ---------------*/
        $this->start_controls_section(
			'heading_team_name',
			[
				'label'		 	=> __( 'Team Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'team_name_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'team_name_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .team-name',
			]
		);

        $this->add_responsive_control(
			'team_name_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Team Style ---------------*/

        

        

        /*  ---------------  Dots Style ---------------*/
        $this->start_controls_section(
			'dots_style',
			[
				'label'		 	=> __( 'Dots', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'dots_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'dots_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);
        $this->add_control(
            'dots_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-team.slick-dots button' => 'Background color: {{VALUE}}',
                ],
            ]
        );

       

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .playrex-team.slick-dots button',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'dots_Hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
        $this->add_control(
            'dots_bg_color_active',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-team.slick-dots button, {{WRAPPER}} .playrex-team.slick-dots .slick-active button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'dots_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .playrex-team.slick-dots button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .playrex-team.slick-dots button:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  ---------------  Dots Style End ---------------*/


        /*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'button_tab_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);

        $this->add_control(
			'button_type',
			[
				'label' => __('Icon type', 'playrex'),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
                'default' => 'default',
				'options' => [
					'default'  => __('Inline Button', 'playrex'),
					'fullwidth-button' => __('Full Width', 'playrex'),
				],
			]
		);

        $this->add_control(
            'button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-bottom .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-bottom .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .team-bottom .vs-btn',
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-bottom .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-bottom .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'button_tab_hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
		$this->add_control(
            'button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-bottom .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-bottom .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

	}

	protected function render() {

    // data-slide-show="1" data-fade="true" data-dots="true" data-arrows="true"

        $settings = $this->get_settings_for_display();

        $team_repeaters = $settings['team_repeater'];

        if( 'yes' == $settings['active_slider']){

            $this->add_render_attribute( 'wrapper', 'class', ['row playrex-team'] );

            if($settings['slider_arrows'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-arrows',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-arrows',  'false' );
            }
            if($settings['slider_dots'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-dots',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-dots',  'false' );
            }
            if($settings['slider_autoplay'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'false' );
            }
            $this->add_render_attribute( 'wrapper', 'data-slide-to-show',  $settings['slide_show_item']);
        }else{
            $this->add_render_attribute( 'wrapper', 'class', ['row'] );
        }

        // layout2

        $team_style = $settings['team_style'];

        if('style-one' == $team_style){
            $this->add_render_attribute( 'version', 'class',  ['col-xl-4 team-style1']);
        }elseif('style-three' == $team_style){
            $this->add_render_attribute( 'version', 'class',  ['col-md-6 col-xl-4 team-style1 layout3']);
        }else{
            $this->add_render_attribute( 'version', 'class',  ['col-md-6 col-xl-4 team-style1 layout2']);
        }





    ?>

        <div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?> >
            <?php foreach($team_repeaters as $team_repeater): ?>
                <div <?php echo $this->get_render_attribute_string( 'version' ); ?>>
                    <div class="team-body">

                        <?php if(!empty($team_repeater['team_thumb']['url'])): ?>
                            <div class="team-logo">
                                <a href="<?php echo esc_url($team_repeater['button_url']) ?>">
                                    <?php
                                        echo playrex_img_tag([
                                            'url' => $team_repeater['team_thumb']['url'],
                                        ]);
                                    ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($team_repeater['team_name']) ): ?>
                            <h3 class="team-name h4">
                                <a href="<?php echo esc_url($team_repeater['button_url']) ?>" class="text-inherit">
                                    <?php echo esc_html($team_repeater['team_name']); ?>
                                </a>
                            </h3>
                        <?php endif; ?>

                        <?php if(!empty($team_repeater['team_group_membar']['url']) ): ?>
                            <div class="team-avaters">
                                <?php
                                    echo playrex_img_tag([
                                        'url' => $team_repeater['team_group_membar']['url'],
                                    ]);
                                ?>
                                <?php if(!empty($team_repeater['team_memabr_count']) ): ?>
                                    <span class="total-avater">
                                        <?php echo esc_html($team_repeater['team_memabr_count']); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <div class="team-bottom">
                            <?php if(!empty($team_repeater['team_team_wins']) ): ?>
                                <div class="team-info">
                                    <?php echo wp_kses_post($team_repeater['team_team_wins']); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($team_repeater['team_team_loses']) ): ?>
                                <div class="team-info">
                                    <?php echo wp_kses_post($team_repeater['team_team_loses']); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($team_repeater['team_team_draws']) ): ?>
                                <div class="team-info">
                                <?php echo wp_kses_post($team_repeater['team_team_draws']); ?>
                                </div>
                            <?php endif; ?>

                            <?php if(!empty($team_repeater['button_text'])):?>
                                <a href="<?php echo esc_url($team_repeater['button_url']) ?>" class="vs-btn">
                                   <?php echo esc_html($team_repeater['button_text']) ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
    <?php
	}
}