<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Testimonial extends Widget_Base {

	public function get_name() {
		return 'playrextestimonial';
	}

	public function get_title() {
		return __( 'Testimonial', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'testimonial', 'slider','reviw', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_testimonial',
			[
				'label'		 	=> __( 'Testimonial', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        /*  --------------- Repeater Section ---------------*/

        $testimonial_repeater = new Repeater();

        /*  --------------- Top Section ---------------*/


        $this->add_control(
			't_section_title',
			[
				'label' 	=> __( 'Section Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'CLIENTS TESTIMONIALS', 'playrex' ),
                'label_block'   => true,
			]
        );

        $this->add_control(
			't_section_sub_title',
			[
				'label' 	=> __( 'Section Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'CLIENTS TESTIMONIALS', 'playrex' ),
                'label_block'   => true,
			]
        );

        $testimonial_repeater->add_control(
			'testimonial_image',
			[
				'label' 		=> __( 'Client Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $testimonial_repeater->add_control(
			'testimonial_content',
			[
				'label' 	=> __( 'Client Feedback', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        $testimonial_repeater->add_control(
			'testimonial_author',
			[
				'label' 	=> __( 'Client Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        $testimonial_repeater->add_control(
			'testimonial_designation',
			[
				'label' 	=> __( 'Designation', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

        $testimonial_repeater->add_control(
            'cleint_rating',
            [
                'label'             => __('Client Rating', 'playrex'),
                'type'              => Controls_Manager::SELECT,
                'default'           => 'style-one',
                'options'           => [
                    '1'    =>   __('1',     'playrex'),
                    '2'    =>   __('2',     'playrex'),
                    '3'    =>   __('3',     'playrex'),
                    '4'    =>   __('4',     'playrex'),
                    '5'    =>   __('5',     'playrex'),
                ],
            ]
        );
        /*  --------------- End  Section ---------------*/

        $this->add_control(
			'testimonial_repeater',
			[
				'label' 		=> __( 'Testimonial', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $testimonial_repeater->get_controls(),
				'default' 		=> [
					[
						'testimonial_content'         => __( 'laying out print, graphic or web designs. The passage is
                        attributed to an unknown typesetter in the 15th century who is thought to have ', 'playrex' ),
						'testimonial_author'         => __( 'Jerzzy Lamot', 'playrex' ),
						'testimonial_designation'         => __( 'Market Manager', 'playrex' ),
						'cleint_rating'         => __( '5', 'playrex' ),
                        'testimonial_image' 	 => Utils::get_placeholder_image_src(),
					],
					[
						'testimonial_content'  => __( 'The placeholder text, beginning with the line “Lorem ipsum
                        dolor sit amet, consectetur adipiscing elit”, looks like Latin because in its
                        yout was Latin', 'playrex' ),
						'testimonial_author'   => __( 'Peter Parket', 'playrex' ),
						'testimonial_designation'         => __( 'Pro Gammer', 'playrex' ),
						'cleint_rating'        => __( '5', 'playrex' ),
                        'testimonial_image'    => Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ testimonial_author }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/
        $this->end_controls_section();

        


        /*  --------------- Box Style Section ---------------*/
        $this->start_controls_section(
			'testimonial_box_style',
			[
				'label'		 	=> __( 'Testimonial Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-style1' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();
        /*  --------------- End Box Style Section ---------------*/


        /*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Title ', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .sec-title',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/


        /*  --------------- Sub Title ---------------*/
        $this->start_controls_section(
			'sub_title',
			[
				'label'		 	=> __( 'Sub Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'subtitle_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .sec-subtitle',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/



        /*  --------------- Review Style ---------------*/
        $this->start_controls_section(
			'reviw_title',
			[
				'label'		 	=> __( 'Review Text', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'reviw_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-style1 .testi-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'reviw_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .testi-style1 .testi-text',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Review Style ---------------*/


        /*  --------------- Client Name ---------------*/
        $this->start_controls_section(
			'client_name',
			[
				'label'		 	=> __( 'Client Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'client_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-style1 .testi-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'client_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .testi-style1 .testi-name',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Client Style ---------------*/

        /*  --------------- designation Name ---------------*/
        $this->start_controls_section(
			'designation_name',
			[
				'label'		 	=> __( 'Client Designation', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'designation_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-style1 .testi-degi' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'designation_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .testi-style1 .testi-degi',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Review Style ---------------*/


        /*  --------------- Rating Start ---------------*/
        $this->start_controls_section(
			'rating_style',
			[
				'label'		 	=> __( 'Rating', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'rating_active_color',
            [
                'label'     => __('Active Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-rating i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'rating_color',
            [
                'label'     => __('Active Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-rating i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
			'rating_size',
			[
				'label' => esc_html__( 'Size', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .testi-rating' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        /*  --------------- End Review Style ---------------*/

       


        /*  --------------- Thumnail Style ---------------*/
        $this->start_controls_section(
			'heading_Client_logo',
			[
				'label'		 	=> __( 'Client Logo', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
			'Client_logo_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-quote' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Thumb Style ---------------*/



        /*  ---------------  Arrow Style ---------------*/
        $this->start_controls_section(
			'arrow_style',
			[
				'label'		 	=> __( 'Arrow', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->start_controls_tabs( 'arrow_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab(
			'arrow_normal',
			[
				'label' => esc_html__( 'Normal', 'playrex' ),
			],
		);
        $this->add_control(
            'arrow_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-btns .icon-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_border_colors',
            [
                'label'     => __('Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-btns .icon-btn' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-btns .icon-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .sec-btns .icon-btn',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab(
			'arrow_Hover',
			[
				'label' => esc_html__( 'Hover', 'playrex' ),
			],
		);
        $this->add_control(
            'border_color_arrow',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-btns .icon-btn:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-btns .icon-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-btns .icon-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .sec-btns .icon-btn:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  ---------------  Arrow Style End ---------------*/
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        $testimonial_repeaters = $settings['testimonial_repeater'];





        ?>
            <div class="row justify-content-center justify-content-lg-between">
                <div class="col-md-8 col-lg-5 col-xl-5 align-self-center text-center text-lg-start">
                    <div class="title-area">

                        <?php if(!empty($settings['t_section_title']) ): ?>
                            <span class="sec-subtitle">
                                <?php echo esc_html( $settings['t_section_title'] ); ?>
                            </span>
                        <?php endif; ?>
                        
                        <?php if(!empty($settings['t_section_sub_title']) ): ?>
                            <h2 class="sec-title">
                                <?php echo esc_html($settings['t_section_sub_title']); ?>
                            </h2>
                        <?php endif; ?>

                    </div>
                    <div class="sec-btns mb-30">
                        <button data-slick-prev="#testislide1" class="icon-btn"><i class="fas fa-chevron-left"></i></button>
                        <button data-slick-next="#testislide1" class="icon-btn"><i class="fas fa-chevron-right"></i></button>
                    </div>
                </div>
                <div class="col-lg-auto">
                        <svg class="svg-hidden">
                            <clipPath id="testi-clip2" clipPathUnits="objectBoundingBox">
                                <path
                                    d="M1,1 L0.755,0.97 L0.806,0.925 L0,0.851 L0.003,0.851 L0.003,0 L0.997,0 L0.997,0.851 L0.999,0.851 L1,1">
                                </path>
                            </clipPath>
                        </svg>
                        <div class="testi-style1" id="testislide1">
                            <?php foreach($testimonial_repeaters as $tm_repeater): ?>
                            <div>
                                <div class="testi-body">
                                    <?php if($tm_repeater['testimonial_image']['url'] ): ?>
                                        <div class="testi-quote">
                                            <?php
                                                echo playrex_img_tag([
                                                    'url' => $tm_repeater['testimonial_image']['url'],
                                                ]);
                                            ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(!empty($tm_repeater['testimonial_content']) ): ?>
                                        <p class="testi-text">
                                            <?php echo esc_html($tm_repeater['testimonial_content']); ?>
                                        </p>
                                    <?php endif; ?>

                                    <?php if(!empty($tm_repeater['testimonial_author']) ): ?>
                                        <h3 class="testi-name h2">
                                            <?php echo esc_html($tm_repeater['testimonial_author']); ?>
                                        </h3>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($tm_repeater['testimonial_designation']) ): ?>
                                        <span class="testi-degi">
                                            <?php echo esc_html($tm_repeater['testimonial_designation']); ?>
                                        </span>
                                    <?php endif; ?>

                                    <?php if( ! empty( $tm_repeater['cleint_rating'] ) ): ?>
                                        <div class="testi-rating">
                                            <?php for ( $i = 0; $i < 5; $i++ ) :?>
                                                <i class="fas fa-star"></i>
                                            <?php endfor; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
        <?php
	}
}