<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Tournament extends Widget_Base {

	public function get_name() {
		return 'playrexpritournament';
	}

	public function get_title() {
		return __( 'Tournament', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'tournament','playrex', 'match' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_tournament',
			[
				'label' 	=> __( 'Tournament', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );


		$this->add_control(
			'active_slider',
			[
				'label' 		=> __( 'Active Slider', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		

		/*  --------------- Repeater Section ---------------*/

        $tournament_repeater = new Repeater();

        /*  --------------- Feature Match Section ---------------*/

		$tournament_repeater->add_control(
			'tournament_background',
			[
				'label' 		=> __( 'Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$tournament_repeater->add_control(
			'tournament_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$tournament_repeater->add_control(
			'tournament_date',
			[
				'label' 	=> __( 'Date', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );
		$tournament_repeater->add_control(
			'tournament_dis',
			[
				'label' 	=> __( 'Discription', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );
		$tournament_repeater->add_control(
			'tournament_info_one',
			[
				'label' 	=> __( 'Tournament Info One', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );
		$tournament_repeater->add_control(
			'tournament_info_two',
			[
				'label' 	=> __( 'Tournament Info Two', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );
        $tournament_repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
			]
        );

        $tournament_repeater->add_control(
			'button_url',
			[
				'label' 	=> __( 'Button Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$tournament_repeater->add_control(
			'tournament_wraper_url',
			[
				'label' 	=> __( 'Box Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		$this->add_control(
			'tournament_repeaters',
			[
				'label' 		=> __( 'Match', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $tournament_repeater->get_controls(),
				'default' 		=> [
					[
						'tournament_title'        => __( 'The Sims Dim', 'playrex' ),
						'tournament_date'         => __( 'date', 'playrex' ),
						'tournament_dis'         => __( 'iquam lorem ante, dapibus', 'playrex' ),
                        'tournament_background' 	 => Utils::get_placeholder_image_src(),
                        'tournament_info_one'      => __( '63 Players', 'playrex' ),
                        'tournament_info_two'      => __( 'Prize Pool', 'playrex' ),
                        'button_text'        => __( 'Book Now', 'playrex' ),
                        'button_url'         => __( '#', 'playrex' ),
                        'tournament_wraper_url'         => __( '#', 'playrex' ),

                    ],
				],
				'title_field' 	=> '{{{ tournament_title }}}',
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Featurematch Style ---------------*/

		/*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );


        $this->add_control(
            'shape_color',
            [   
                'label'     => __('Shape Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-style4 .tournament-shape1, {{WRAPPER}} .tournament-style4' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [   
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-name .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-name',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

		/*  --------------- Dis Style ---------------*/
		$this->start_controls_section(
			'dis_title',
			[
				'label'		 	=> __( 'Discription', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'tournament_dis_color',
            [   
                'label'     => __('Info label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-text' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'dis_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-text',
			]
		);

		$this->end_controls_section();
		/*  --------------- Dis Style ---------------*/

		/*  --------------- Tournament Label ---------------*/
        $this->start_controls_section(
			'tournament_label_title',
			[
				'label'		 	=> __( 'Tournament Label', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'tournament_label_color',
            [   
                'label'     => __('Info label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-info-label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tournament_info_color',
            [   
                'label'     => __('Info Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-info-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_label_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-info-label',
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_info_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-info-text',
			]
		);
        $this->end_controls_section();
        /*  --------------- Tournament Label ---------------*/


		

		/*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'fm_button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'fm_button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'fm_button_tab_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);

        $this->add_control(
            'fm_button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'fm_button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_responsive_control(
			'fm_button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'fm_button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'fm_button_tab_hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
		$this->add_control(
            'fm_button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

		/*  ---------------  nav Style ---------------*/
        $this->start_controls_section(
			'fm_nav_style',
			[
				'label'		 	=> __( 'Arrow', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'fm_nav_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'fm_nav_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);

        $this->add_control(
            'fm_nav_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_nav_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'fm_nav_Hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
		$this->add_control(
            'fm_nav_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_nav_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();



    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		


		$tournament_repeaters = $settings['tournament_repeaters'];
		?>
		<div class="tournament-wrap2">
			<svg class="svg-hidden">
				<clipPath id="tournament-clip-1" clipPathUnits="objectBoundingBox">
					<path d="M0.941,0.245 L0.852,0.193 L0.708,0.998 L0.708,0.001 L1,0 L0.941,0.245 M0,0.002 L0.708,0.002 L0.708,1 L0,1 L0,0.002"></path>
				</clipPath>
			</svg>
			<div class="tournament-nav-slide row tournament-nav gx-10" id="tournament-menu-nav">

				<?php foreach($tournament_repeaters as $t_repeater): ?>
					<?php if(!empty($t_repeater['tournament_background']['url']) ): ?>
						<div class="col-xl-4">
							<div class="tournament-thumb1">
								<?php
									echo playrex_img_tag([
										'url' => $t_repeater['tournament_background']['url'],
									]);
								?>
							</div>
						</div>
					<?php endif; ?>
				<?php endforeach; ?>
				
			</div>

			<div class="tournament-content-slider"  id="tournament-style-one">
				<?php foreach($tournament_repeaters as $t_repeater): ?>
					<div>
						<div class="tournament-style4">
							<div class="tournament-shape1"></div>
							<?php if(!empty($t_repeater['tournament_background']['url']) ): ?>
								<div class="tournament-img">
									<?php
										echo playrex_img_tag([
											'url' => $t_repeater['tournament_background']['url'],
										]);
									?>
								</div>
							<?php endif; ?>
							<div class="tournament-body">
								<?php if(!empty($t_repeater['tournament_date'])): ?>
									<p class="tournament-date">
										<?php echo wp_kses_post($t_repeater['tournament_date']); ?>
									</p>
								<?php endif; ?>
								
								<?php if(!empty($t_repeater['tournament_title'])): ?>
									<h3 class="tournament-name h2">
										<a href="<?php echo esc_url($t_repeater['tournament_wraper_url']) ?>" class="text-inherit">
											<?php echo wp_kses_post($t_repeater['tournament_title']); ?>
										</a>
									</h3>
								<?php endif; ?>
								
								<?php if(!empty($t_repeater['tournament_dis'])): ?>
									<p class="tournament-text">
										<?php echo wp_kses_post($t_repeater['tournament_dis']); ?>
									</p>
								<?php endif; ?>
								<div class="tournament-bottom">

									<?php if(!empty($t_repeater['tournament_info_one'])): ?>
										<div class="tournament-info">
											<?php echo wp_kses_post($t_repeater['tournament_info_one']); ?>
										</div>
									<?php endif; ?>

									<?php if(!empty($t_repeater['tournament_info_two'])): ?>
										<div class="tournament-info">
											<?php echo wp_kses_post($t_repeater['tournament_info_two']); ?>
										</div>
									<?php endif; ?>
								</div>

								<?php if(!empty($t_repeater['button_text'])): ?>
									<a href="<?php echo esc_url($t_repeater['button_url']) ?>" class="vs-btn">
										<?php echo esc_html($t_repeater['button_text']); ?>
									</a>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
    <?php
	}
}