<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Playrex_Section_Title_Widget extends Widget_Base {

	public function get_name() {
		return 'playrexsectiontitle';
	}

	public function get_title() {
		return __( 'Section Title', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-heading';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Section Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'section_title_style',
			[
				'label' 	=> __( 'Title Style', 'playrex' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'playrex' ),
					'2' 		=> __( 'Style Two', 'playrex' ),
				],
			]
		);

		$this->add_control(
			'title_shap',
			[
				'label' 		=> __( 'Show Shape', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->add_control(
			'show_title',
			[
				'label' 		=> __( 'Show Titlte', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->add_control(
			'show_subtitle',
			[
				'label' 		=> __( 'Show Sub Titlte', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);


        $this->add_control(
			'show_dis',
			[
				'label' 		=> __( 'Show  Discription', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		

        $this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'playrex' ),
				'condition' => [
                    'show_title'    => 'yes',
                ]
			]
        );

        $this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'playrex' ),
				'condition' => [
                    'show_subtitle'    => 'yes',
                ]
			]
        );

		$this->add_control(
			'section_dis',
			[
				'label' 	=> __( 'Section Description', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Sign up to our newsletter so you never miss out on product drops, news and exclusive offers.', 'playrex' ),
				'condition' => [
                    'show_dis'    => 'yes'
                ],
			]
        );

        $this->add_responsive_control(
			'section_title_align',
			[
				'label' 		=> __( 'Alignment', 'playrex' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'playrex' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'playrex' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'playrex' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'center',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'text-align: {{VALUE}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Section Title Style', 'playrex' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'section_wrapper_margin',
			[
				'label' 		=> __( 'Section Wrapper Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'section_wrapper_padding',
			[
				'label' 		=> __( 'Section Wrapper Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' 	=> 'after'
			]
		);

        $this->add_control(
			'section_title_color',
			[
				'label' 	=> __( 'Section Title Color', 'playrex' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'section_title!'    => ''
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __( 'Section Title Typography', 'playrex' ),
                'selector' 	=> '{{WRAPPER}} .sec-title',
                'condition' => [
                    'section_title!'    => ''
                ]
			]
		);

        $this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __( 'Section Title Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'section_title!'    => ''
                ]
			]
        );

        $this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __( 'Section Title Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' 	=> [
                    'section_title!'    => ''
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'playrex' ),
				'selector' 	=> '{{WRAPPER}} .sec-title',
				'condition' => [
                    'section_title!'    => ''
                ],
                'separator' => 'after'
			]
		);

		$this->add_control(
			'section_subtitle_color',
			[
				'label' 		=> __( 'Section Subtitle Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                ],
                'condition' 	=> [
                    'section_subtitle!'    => ''
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_subtitle_typography',
				'label' 	=> __( 'Section Subtitle Typography', 'playrex' ),
                'selector' 	=> '{{WRAPPER}} .sec-title',
                'condition' => [
                    'section_subtitle!'    => ''
                ],
			]
        );

        $this->add_responsive_control(
			'section_subtitle_margin',
			[
				'label' 		=> __( 'Section Subtitle Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sec-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'section_subtitle!'    => ''
                ],
			]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'section_title_dis_section',
			[
				'label' => __( 'Discription', 'playrex' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition' => [
                    'show_dis'    => 'yes'
                ],
			]
		);
		$this->add_control(
			'section_dis_color',
			[
				'label' 		=> __( 'Section Subtitle Color', 'playrex' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .form-text' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_dis_typography',
				'label' 	=> __( 'Section Subtitle Typography', 'playrex' ),
                'selector' 	=> '{{WRAPPER}} .form-text',
			]
        );

        $this->add_responsive_control(
			'section_dis_margin',
			[
				'label' 		=> __( 'Section Subtitle Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .form-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $section_title = $settings['section_title'];
        $section_subtitle = $settings['section_subtitle'];
        $section_title_align = $settings['section_title_align'];
        $title_shap = $settings['title_shap'];
        $this->add_render_attribute( 'wrapper', 'class', ['title-area', $section_title_align]  );

		$show_title = $settings['show_title'];
		$show_subtitle = $settings['show_subtitle'];
		$show_dis = $settings['show_dis'];
		$section_dis = $settings['section_dis'];
		
        ?>
            <div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>

                <?php if(!empty($section_subtitle) && $show_subtitle == 'yes' ): ?>
                    <span class="sec-subtitle"><?php echo wp_kses_post($section_subtitle); ?></span>
                <?php endif; ?>

                <?php if(!empty($section_title) && $show_title == 'yes'): ?>
                    <h2 class="sec-title"><?php echo wp_kses_post($section_title); ?></h2>
                <?php endif; ?>

                <?php if(!empty($show_dis) && $show_dis == 'yes'): ?>
                    <p class="form-text">
						<?php echo esc_html($section_dis); ?>
					</p>
                <?php endif; ?>
                
                <?php if($title_shap == 'yes'): ?>
                    <div class="sec-line"></div>
                <?php endif; ?>

            </div>
        <?php
	}
}