<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Team  Box Widget .
 *
 */

class Playrex_Bottom_Info extends Widget_Base {

	public function get_name() {
		return 'playrexbottominfo';
	}

	public function get_title() {
		return __( 'Team Bottom Info', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'palyer','team', 'bottom info' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_feature',
			[
				'label' 	=> __( 'Team Bottom', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		/*  --------------- Repeater Section ---------------*/
        $bottominfo_repeater = new Repeater();

        /*  --------------- Team   Bottom Section ---------------*/
		$bottominfo_repeater->add_control(
			'team_info_number',
			[
				'label' 	=> __( 'Team Info Number', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '07', 'playrex' ),
                'label_block'   => true,
			]
        );
		$bottominfo_repeater->add_control(
			'team_info_label',
			[
				'label' 	=> __( 'Team Info Label', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'WINS', 'playrex' ),
                'label_block'   => true,
			]
        );
		
		$this->add_control(
			'bottominfo_repeater',
			[
				'label' 		=> __( 'Team Bottom', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $bottominfo_repeater->get_controls(),
				'default' 		=> [
					[
						
                        'team_info_number' => __('07', 'playrex'),
                        'team_info_label' => __('WINS', 'playrex'),
                    ],
					[
						
                        'team_info_number' => __('19', 'playrex'),
                        'team_info_label' => __('WINS', 'playrex'),
                    ],
					[
						
                        'team_info_number' => __('11', 'playrex'),
                        'team_info_label' => __('LOSES', 'playrex'),
                    ],
					
				],
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Team  Style ---------------*/


        /*  --------------- Number Style ---------------*/
        $this->start_controls_section(
			'number_title',
			[
				'label'		 	=> __( 'Number', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'number_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-box1 .team-info-number' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'number_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .team-box1 .team-info-number',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Number Style ---------------*/

        /*  --------------- Number Style ---------------*/
        $this->start_controls_section(
			'label_title',
			[
				'label'		 	=> __( 'Label', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'label_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-box1 .team-info-label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'label_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .team-box1 .team-info-label',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Number Style ---------------*/


        /*  --------------- Wraper Style ---------------*/
        $this->start_controls_section(
			'infor_wraper',
			[
				'label'		 	=> __( 'Wraper', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_responsive_control(
			'wraper_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-box1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Wraper Style ---------------*/
        

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$bottominfo_repeaters = $settings['bottominfo_repeater'];
		
        ?>
            <div class="team-box1">
                <div class="team-bottom">
                    <?php foreach($bottominfo_repeaters as $bottominfo_repeater): ?>
                        <div class="team-info">
                            <?php if(!empty($bottominfo_repeater['team_info_number'])): ?>
                                <span class="team-info-number">
                                    <?php echo esc_html($bottominfo_repeater['team_info_number']); ?>
                                </span>
                            <?php endif; ?>
                            
                            <?php if($bottominfo_repeater['team_info_label']): ?>
                                <span class="team-info-label">
                                    <?php echo esc_html($bottominfo_repeater['team_info_label']) ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
		<?php
        
	}
}