<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Tournament_Body extends Widget_Base {

	public function get_name() {
		return 'playrextournamentbody';
	}

	public function get_title() {
		return __( 'Tournament Body', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-square playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'tournamentbody', 'tournament', 'details', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_tournamentbody',
			[
				'label'		 	=> __( 'Tournament Body', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        /*  --------------- Top Section ---------------*/
        $this->add_control(
			't_bg',
			[
				'label' 		=> __( 'Background Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'icon_image',
			[
				'label' 		=> __( 'Icon Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			't_day',
			[
				'label' 	=> __( 'Day', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'JUL31ST', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			't_time',
			[
				'label' 	=> __( 'Time', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'SUN 00:00 PKT', 'playrex' ),
                'label_block'   => true,
			]
        );
        
        $this->add_control(
			't_price',
			[
				'label' 	=> __( 'Price', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '$150.00', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->add_control(
			't_icon',
			[
				'label' 	=> __( 'Icon', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'fas fa-trophy-alt', 'playrex' ),
                'label_block'   => true,
			]
        );
        $this->end_controls_section();
        

        /*  --------------- Container Section ---------------*/ 
        $this->start_controls_section(
			't_wraper',
			[
				'label'		 	=> __( 'Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_responsive_control(
			'wraper_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .tournament-img1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();

        /*  --------------- Day nad time Section ---------------*/ 
        $this->start_controls_section(
			'date_title',
			[
				'label'		 	=> __( 'Date & Time', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'date_color',
            [
                'label'     => __('Date Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .day' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'date_typography',
				'label' 		=> __( 'Day Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .day',
			] 
		);

        // time
        $this->add_control(
            'time_color',
            [
                'label'     => __('Time Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'time_typography',
				'label' 		=> __( 'Time Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .time',
			] 
		);


        $this->add_responsive_control(
			'time_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();

        /*  ---------------  Price Section ---------------*/
        $this->start_controls_section(
			'price_title',
			[
				'label'		 	=> __( 'Price', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'price_color',
            [
                'label'     => __('Price Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-price' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'price_typography',
				'label' 		=> __( 'Price Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-price',
			] 
		);
        $this->add_control(
            'price_icon',
            [
                'label'     => __('Price Icon', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-price i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
			'price_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .tournament-price i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'price_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .tournament-price i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Price Section ---------------*/

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        $t_bg = $settings['t_bg'];
        $icon_image = $settings['icon_image'];
        $t_day = $settings['t_day'];
        $t_time = $settings['t_time'];
        $t_price = $settings['t_price'];
        $t_icon = $settings['t_icon'];

        ?>
            <div class="tournament-img1">
                <?php if(!empty($icon_image['url'])): ?>
                    <div class="tournament-badges">
                        <?php 
                            echo playrex_img_tag([
                                'url' => $icon_image['url'],
                            ]);
                        ?>
                    </div>
                <?php endif; ?>

                <?php if(!empty($t_bg['url'])): ?>           
                    <?php 
                        echo playrex_img_tag([
                            'url' => $t_bg['url'],
                        ]);
                    ?>
                <?php endif; ?>


                <div class="tournament-metas">
                    <div class="tournament-date">

                        <?php if(!empty($t_day) ): ?>
                            <span class="day"><?php echo esc_html($t_day); ?></span>
                        <?php endif;?>

                        <?php if(!empty($t_time) ): ?>
                            <div class="time">
                                <?php echo esc_html($t_time); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <?php if(!empty($t_price)):  ?>
                        <div class="tournament-price">
                            <?php if($t_icon): ?>
                                <i class="<?php echo esc_attr($t_icon); ?>"></i>
                            <?php endif; ?>
                            <?php echo esc_html($t_price); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
	}
}