<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_tournament_Filter extends Widget_Base {

	public function get_name() {
		return 'playrextournament_filter';
	}

	public function get_title() {
		return __( 'Tournament Filter', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'tournament filter','filter', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_tournament_filter_section',
			[
				'label' 	=> __( 'Tournament Filter', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'all_text', [
				'label' 		=> __( 'All Text', 'playrex' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Web Development' , 'playrex' ),
				'label_block' 	=> true,
			]
        );
		
		/*  --------------- Repeater Section ---------------*/

        $t_filter_repeater = new Repeater();

        /*  --------------- Feature Match Section ---------------*/

		
        $t_filter_repeater->add_control(
			'filter_title', [
				'label' 		=> __( 'Filter Menu Name', 'playrex' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Web Development' , 'playrex' ),
				'label_block' 	=> true,
			]
        );

		$t_filter_repeater->add_control(
			'category_one',
			[
				'label' 		=> __( 'Write Category', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'upcomingmatches', 'playrex' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'playrex' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);
		$t_filter_repeater->add_control(
			'category_two',
			[
				'label' 		=> __( 'Write Category', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'latestresult', 'playrex' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'playrex' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);
		$t_filter_repeater->add_control(
			'category_three',
			[
				'label' 		=> __( 'Write Category', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'oldtresult', 'playrex' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'playrex' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);
		$t_filter_repeater->add_control(
			'category_four',
			[
				'label' 		=> __( 'Write Category', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'others', 'playrex' ),
				'placeholder' 	=> __( 'Type Your Tab Text Here', 'playrex' ),
				'description' 	=> __( 'Please Write The Same Name As You Write In Tab Text.' )
			]
		);

        // Content
		$t_filter_repeater->add_control(
			'team_name_one',
			[
				'label' 		=> __( 'Team Name One', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Rabbits Star', 'playrex' ),
			]
		);

        $t_filter_repeater->add_control(
			'team_one_thumb',
			[
				'label' 		=> __( 'Image One', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$t_filter_repeater->add_control(
			'team_name_two',
			[
				'label' 		=> __( 'Team Name Two', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Bunny Hood II', 'playrex' ),
			]
		);
        $t_filter_repeater->add_control(
			'team_two_thumb',
			[
				'label' 		=> __( 'Image Two', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		// Right SIde Content
		$t_filter_repeater->add_control(
			'match_label',
			[
				'label' 		=> __( 'Label', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( '3v3, Multi Elimination', 'playrex' ),
				'label_block' 	=> true,
			]
		);
		$t_filter_repeater->add_control(
			'match_name',
			[
				'label' 		=> __( 'Match Name', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'The 19th Asian Games Hangzhou', 'playrex' ),
				'label_block' 	=> true,
			]
		);
		$t_filter_repeater->add_control(
			'match_date',
			[
				'label' 		=> __( 'Date', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'DECEMBER 11, 2022 3:00 PM', 'playrex' ),
				'label_block' 	=> true,
			]
		);

		$t_filter_repeater->add_control(
			'details_url',
			[
				'label' 		=> __( 'Details Url', 'playrex' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( '#', 'playrex' ),
				'label_block' 	=> true,
			]
		);



		$this->add_control(
			't_filter_repeaters',
			[
				'label' 		=> __( 'Match', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $t_filter_repeater->get_controls(),
				'default' 		=> [
					[
						'filter_title'       => __('Web Development', 'playrex'),
						'team_name_one'      => __('Rabbits Star', 'playrex'),
						'team_name_two'      => __('Bunny Hood II', 'playrex'),
						'match_label'        => __('3v3, Multi Elimination', 'playrex'),
						'match_date'         => __('DECEMBER 11, 2022 3:00 PM', 'playrex'),
						'match_name'         => __('The 19th Asian Games Hangzhou', 'playrex'),
						'details_url'         => __('#', 'playrex'),
                        'team_one_thumb' 	 => Utils::get_placeholder_image_src(),
                        'team_two_thumb' 	 => Utils::get_placeholder_image_src(),

                    ],
				],
				'title_field' 	=> '{{{ filter_title }}}',
			]
		);
       
        $this->end_controls_section();
        /*  --------------- End Featurematch Style ---------------*/
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
		$t_filter_repeaters = $settings['t_filter_repeaters'];
        
        ?>
            <div class="match-menu2 filter-menu-active">
                <?php if(!empty($settings['all_text'] )): ?>
                    <button data-filter="*" class="active">
                        <?php echo esc_html($settings['all_text']); ?>
                    </button>
                <?php endif; ?>

                <?php foreach($t_filter_repeaters as $filter_data):
                        $data 			= strtolower( $filter_data['filter_title'] );
                        $replace 		= array(' ','-',' - ');
                        $with 			= array('','','');
                        $final_data 	= str_replace( $replace, $with, $data );
                    ?>
					<?php  if(!empty($final_data)): ?>
						<button data-filter=".<?php echo esc_attr($final_data); ?>">
							<?php echo esc_html($filter_data['filter_title']); ?>
						</button>
					<?php endif; ?>
                <?php endforeach; ?>
            </div>

            <div class="filter-active">
                <?php foreach($t_filter_repeaters as $single_filter):
                    $cat_one 			= strtolower( $single_filter['category_one'] );
                    $cat_two 			= strtolower( $single_filter['category_two'] );
                    $cat_three 			= strtolower( $single_filter['category_three'] );
                    $cat_four 			= strtolower( $single_filter['category_four'] );
                    $replace 			= array(' ','-',' - ');
                    $with 				= array('','','');
                    $cat_one_final 		= str_replace( $replace, $with, $cat_one );
                    $cat_two_final 		= str_replace( $replace, $with, $cat_two );
                    $cat_three_final 	= str_replace( $replace, $with, $cat_three );
                    $cat_four_final 	= str_replace( $replace, $with, $cat_four );

                    $this->add_render_attribute( 'wrapper', 'class', [ 'match-style3 filter-item'] );
                    $this->add_render_attribute( 'wrapper', 'class', [ $cat_one_final, $cat_two_final, $cat_three_final, $cat_four_final ] );
                    
                    ?>
                    <div <?php echo  $this->get_render_attribute_string('wrapper') ?>>
                        <div class="match-top">
                            <div class="match-team">

								<?php if(!empty($single_filter['team_name_one'])): ?>
									<h4 class="team-name h6">
										<a href="<?php echo esc_url($single_filter['details_url']); ?>" class="text-inherit">
											<?php echo esc_html($single_filter['team_name_one']); ?>
										</a>
									</h4>
								<?php endif; ?>

								<?php if(!empty($single_filter['team_one_thumb']['url'])): ?>
									<div class="team-logo">
										<?php
											echo '<a href="'.esc_url( $single_filter['details_url'] ).'">';
												echo playrex_img_tag([
													'url' => $single_filter['team_one_thumb']['url'],
												]);
											echo '</a>';
										?>
									</div>
								<?php endif; ?>
                            </div>

                            <div class="match-verses"><span class="text"><?php _e('vs', 'playrex') ?></span></div>
							
							
                            <div class="match-team">
								<?php if(!empty($single_filter['team_name_one'])): ?>
									<h4 class="team-name h6">
										<a href="<?php echo esc_url($single_filter['details_url']); ?>" class="text-inherit">
										<?php echo esc_html($single_filter['team_name_one']); ?>
										</a>
									</h4>
								<?php endif; ?>
								<div class="team-logo">
	                                <?php
										echo '<a href="'.esc_url( $single_filter['details_url'] ).'">';
											if( ! empty( $single_filter['team_two_thumb']['url'] ) ){
												echo playrex_img_tag( [
													'url' => $single_filter['team_two_thumb']['url'],
												] );
											}
										echo '</a>';
									?>
	                            </div>
                            </div>
                        </div>
                        <div class="match-body">
                            <div class="match-content">
								<?php if($single_filter['match_label']): ?>
                                	<span class="match-label"><?php echo esc_html($single_filter['match_label']); ?></span>
								<?php endif; ?>

								<?php if(!empty($single_filter['match_name']) ): ?>
									<h3 class="match-name">
										<a href="<?php echo esc_url( $single_filter['details_url'] ); ?>" class="text-inherit">
											<?php echo esc_html($single_filter['match_name']); ?>
										</a>
									</h3>
								<?php endif; ?>
								
								<?php if($single_filter['match_name']): ?>
									<p class="match-date">
										<?php echo esc_html($single_filter['match_name']); ?>
									</p>
								<?php endif; ?>
                            </div>
                            <a href="https://www.youtube.com/watch?v=_sI_Ps7JSEk" class="vs-btn popup-video"><i
                                class="fab fa-twitch"></i>Watch Stream</a>
                        </div>
                    </div>
                <?php endforeach; ?>


            </div>
    <?php
	}
}
