<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Tournamentmatch Box Widget .
 *
 */
class Playrex_Tournament_History extends Widget_Base {

	public function get_name() {
		return 'tournamenthistory';
	}

	public function get_title() {
		return __( 'Tournament History', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-history playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'tournament','playrex', 'history' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_tournament_history',
			[
				'label' 	=> __( 'Tournament History', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        /*  --------------- Tournament Match Section ---------------*/

        $this->add_control(
			'tournament_icon',
			[
				'label' 		=> __( 'Tournament Icon', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'tournament_logo',
			[
				'label' 		=> __( 'Iournament Logo', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'logo_url',
			[
				'label' 		=> __( 'Logo Url', 'playrex' ),
                'type' 			=> Controls_Manager::TEXT,
                'label_block'   => true,
                'default'   	=> __('#', 'playrex')
			]
        );
		$this->add_control(
			'tournament_year',
			[
				'label' 	=> __( 'Tournament Year', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
                'default'   => __('2005 - 2010', 'playrex')
			]
        );
		$this->add_control(
			'tournament_name',
			[
				'label' 	=> __( 'Tournament Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'   => __('LALIGA CUP', 'playrex'),
                'label_block'   => true,
			]
        );
		$this->add_control(
			'tournament_table_one',
			[
				'label' 	=> __( 'Tournament Table One', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'default'   => __('Total Teams:', 'playrex'),
			]
        );
		$this->add_control(
			'tournament_table_two',
			[
				'label' 	=> __( 'Tournament Table Two', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'default'   => __('Organiger:', 'playrex'),
			]
        );

		$this->add_control(
			'team_name',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'default'   => __('Wizard Wer', 'playrex'),
			]
        );
		$this->add_control(
			'team_degi',
			[
				'label' 	=> __( 'Team Degination', 'playrex' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'label_block'   => true,
                'default'   => __('Champions', 'playrex'),
			]
        );

    
        $this->end_controls_section();
        /*  --------------- End Tournamentmatch Style ---------------*/

		/*  --------------- Year Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Year', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );


        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-year' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-year',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Year Style ---------------*/

		/*  --------------- Tournament Name ---------------*/
		$this->start_controls_section(
			'tname_title',
			[
				'label'		 	=> __( 'Tournament Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'tournament_tname_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5 .tournament-name' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tname_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style5 .tournament-name',
			]
		);

		$this->end_controls_section();
		/*  --------------- Tournament Name ---------------*/

		/*  --------------- Tournament Info Label ---------------*/
        $this->start_controls_section(
			'tournament_label_title',
			[
				'label'		 	=> __( 'Tournament Table', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'tournament_label_color',
            [
                'label'     => __('Label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5 .tournament-table th' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_label_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style5 .tournament-table th',
			]
		);


        $this->add_control(
            'tournament_info_color',
            [
                'label'     => __('Info Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5 .tournament-table td' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_info_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style5 .tournament-table td',
			]
		);
        $this->end_controls_section();
        /*  --------------- Tournament Info Label ---------------*/


        /*  --------------- Team Name ---------------*/
		$this->start_controls_section(
			'name_title',
			[
				'label'		 	=> __( 'Team Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'tournament_name_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5 .team-name' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'team_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style5 .team-name',
			]
		);

		$this->end_controls_section();
		/*  --------------- Team Name ---------------*/


         /*  --------------- Team Name ---------------*/
		$this->start_controls_section(
			'digit_title',
			[
				'label'		 	=> __( 'Team Digination', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'tournament_digi_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5 .team-degi' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'digi_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-style5 .team-degi',
			]
		);

		$this->end_controls_section();
		/*  --------------- Team Name ---------------*/


         /*  --------------- Wraper Name ---------------*/
		$this->start_controls_section(
			'wrapertitle',
			[
				'label'		 	=> __( 'Wraper', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'tournament_wraper_color',
            [
                'label'     => __('Hover Border Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5:hover .tournament-icon, {{WRAPPER}} .tournament-style5:hover .tournament-top, {{WRAPPER}} .tournament-style5:hover .tournament-top:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'tournament_wraper_bg_color',
            [
                'label'     => __('Hover Bg Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-style5:hover .tournament-body, {{WRAPPER}} .tournament-style5:hover .tournament-bottom' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'tournament_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .tournament-style5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_section();
		/*  --------------- Team Name ---------------*/


	

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $icon = $settings['tournament_icon'];
        $logo = $settings['tournament_logo'];
        $year = $settings['tournament_year'];
        $name = $settings['tournament_name'];
        $table_one = $settings['tournament_table_one'];
        $table_two = $settings['tournament_table_two'];
        $team_name = $settings['team_name'];
        $team_degi = $settings['team_degi'];


		?>

        <div class="tournament-style5">
                <div class="tournament-top">
                    <?php if(!empty($year)): ?>
                        <p class="tournament-year">
                            <?php echo esc_html($year); ?>
                        </p>
                    <?php endif; ?>
                    
                    <?php if(!empty($name)): ?>
                        <span class="tournament-name">
                            <?php echo esc_html($name); ?>
                        </span>
                    <?php endif; ?>
                </div>
                <div class="tournament-body">
                    <table class="tournament-table">
                        <tbody>
                            <?php if( ! empty( $table_one ) ): ?>
                                <tr>
                                    <?php echo wp_kses_post( $table_one) ?>
                                </tr>
                            <?php endif; ?>

                            <?php if( ! empty( $table_two ) ): ?>
                                <tr>
                                    <?php echo wp_kses_post( $table_two ) ?>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="tournament-bottom">
                    <?php if(!empty($icon)): ?>
                        <div class="tournament-icon">
                            <?php
                                echo playrex_img_tag([
                                    'url' => $icon['url'],
                                ]);
                            ?>
                        </div>
                    <?php endif; ?>

                    <div class="tournament-team">
                        <?php if( ! empty( $logo ) ): ?>
                            <div class="team-logo">
                                <?php
									echo '<a href="'.esc_url( $settings['logo_url'] ).'">';
	                                    echo playrex_img_tag([
	                                        'url' => $logo['url'],
	                                    ]);
									echo '</a>';
                                ?>
                            </div>
                        <?php endif; ?>

                        <div class="media-body">
                            <?php if(!empty($team_name) ): ?>
                                <h3 class="team-name h5">
                                    <?php echo esc_html($team_name); ?>
                                </h3>
                            <?php endif; ?>
                            <?php if(!empty($team_degi) ): ?>
                                <p class="team-degi">
                                    <?php echo esc_html($team_degi); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
		
        <?php
	}
}