<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Tournament_Schedule_Tab extends Widget_Base {

	public function get_name() {
		return 'playrexscheduletab';
	}

	public function get_title() {
		return __( 'Tournament Schedule Tab', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-hypster playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'scheduletab', 'tab', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_scheduletab',
			[
				'label'		 	=> __( 'Player Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        /*  --------------- Repeater Section ---------------*/
        $scheduletab_repeater = new Repeater();

		$scheduletab_repeater->add_control(
			'scheduletab_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$scheduletab_repeater->add_control(
			'scheduletab_subtitle',
			[
				'label' 	=> __( 'Sub Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
		
        $scheduletab_repeater->add_control(
			'playrex_scheduletab_builder',
			[
				'label'     => __( 'Select Content', 'playrex' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->playrex_tab_build(),
				'default'	=> ''
			]
		);
        $this->add_control(
			'scheduletab_repeaters',
			[
				'label' 		=> __( 'Player Box', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $scheduletab_repeater->get_controls(),
				'default' 		=> [
					[
						'scheduletab_title'  => __('Feb 09, 2023'),
						'scheduletab_subtitle'  => __( 'Day 4 - Thursday', 'playrex' ),
					],
					[
						'scheduletab_title'  => __('AUG 07, 2023'),
						'scheduletab_subtitle'  => __( 'DAY 3 - SUNDAY', 'playrex' ),
					],
					[
						'scheduletab_title'  => __('SEP 01, 2023'),
						'scheduletab_subtitle'  => __( 'DAY 3 - FRIDAY', 'playrex' ),
					],
					[
						'scheduletab_title'  => __('NOV 25, 2023'),
						'scheduletab_subtitle'  => __( 'DAY 4 - SATURDAY', 'playrex' ),
					],
				],
				'title_field' 	=> '{{{ scheduletab_title }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/
        $this->end_controls_section();

		 /*  --------------- Title Style ---------------*/
		 $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-menu1 .match-date' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [   
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-menu1 button:hover .match-date' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-menu1 .match-date',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/


		 /*  --------------- Sub Title Style ---------------*/
		 $this->start_controls_section(
			'heading_sub_title',
			[
				'label'		 	=> __( 'Sub Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'title_sub_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-menu1 .match-day' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_sub_hover_color',
            [   
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-menu1 button:hover .match-day' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_sub_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-menu1 .match-day',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/



		/*  --------------- Box Style Section ---------------*/
        $this->start_controls_section(
			'match_box_style',
			[
				'label'		 	=> __( 'Box', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs( 'box_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'box_tab_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);


        $this->add_control(
            'box_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-menu1 button, {{WRAPPER}} .match-menu1 button:before' => 'background-color: {{VALUE}}',
                ],
                
            ]
        );
        $this->end_controls_tab();

        /*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'box_tab_hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
        $this->add_control(
            'box_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-menu1 button.active, {{WRAPPER}}.match-menu1 button:hover, {{WRAPPER}} .match-menu1 button:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Box Style Section ---------------*/


	}


    public function playrex_tab_build(){

		$playrex_post_query = new WP_Query( array(
			'post_type'				=> 'playrex_tab_build',
			'posts_per_page'	    => -1,
		) );

		$playrex_tab_builder_title_title = array();
		$playrex_tab_builder_title_title[''] = __( 'Select a Title','Playrex');

		while( $playrex_post_query->have_posts() ) {
			$playrex_post_query->the_post();
			$playrex_tab_builder_title_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();
		return $playrex_tab_builder_title_title;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		$scheduletab_repeaters = $settings['scheduletab_repeaters'];

        ?>
            <!-- Tab  -->
            <div class="row gx-30">
                <div class="col-lg-3 col-xl-3">
                    <div class="match-menu1 nav" id="nav-tab" role="tablist">
                        <?php $x = 0; ?>

                        <?php foreach($scheduletab_repeaters as $scheduletab_repeater):
                            if( $x == 0 ){
                                $active = 'active';
                                $area   = 'true';
                            }else{
                                $active = '';
                                $area   = 'false';
                            }
                            
                        ?>
                        

                            <button class="nav-link <?php echo esc_attr($active) ?>" id="nav-matchda<?php echo esc_attr($x) ?>-tab" data-bs-toggle="tab"
                                data-bs-target="#nav-matchda<?php echo esc_attr($x) ?>" type="button" role="tab" aria-controls="nav-matchda<?php echo esc_attr($x) ?>"
                                aria-selected="<?php echo esc_attr($area) ?>">

                                <?php if(!empty($scheduletab_repeater['scheduletab_title'])): ?>
                                    <span class="match-date"><?php echo esc_html($scheduletab_repeater['scheduletab_title']) ?></span>
                                <?php endif; ?>

                                <?php if(!empty($scheduletab_repeater['scheduletab_subtitle'])): ?>
                                    <span class="match-day"><?php echo esc_html($scheduletab_repeater['scheduletab_subtitle']) ?></span>
                                <?php endif; ?>
                            </button>
                        <?php $x++; endforeach; ?>

                    </div>
                </div>
                <div class="col-lg-9 col-xl-9">
                    <?php $x = 0; ?>
                    <div class="tab-content match-tab-content1" id="nav-tabContent">

                        <?php foreach($scheduletab_repeaters as $scheduletab_repeater):
                            if( $x == 0 ){
                                $active = 'active';
                                $area   = 'true';
                            }else{
                                $active = '';
                                $area   = 'false';
                            }
                                
                        ?>
                        <?php if(!empty($scheduletab_repeater['playrex_scheduletab_builder'])): ?>
                            <div class="tab-pane fade show <?php echo esc_attr($active) ?>" id="nav-matchda<?php echo esc_attr($x) ?>" role="tabpanel"
                                aria-labelledby="nav-matchda<?php echo esc_attr($x) ?>-tab">
                                <?php
                                    $elementor = \Elementor\Plugin::instance();
                                    echo $elementor->frontend->get_builder_content_for_display($scheduletab_repeater['playrex_scheduletab_builder']);
                                ?>
                            </div>
                        <?php endif; ?>
                        <?php $x++; endforeach; ?>
                       <!-- end tab contnet -->
                        
                    </div>
                </div>
            </div>

            
	    <?php
	}
}