<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Icon Box Widget .
 *
 */
class Playrex_Tournament_Schedule extends Widget_Base {

	public function get_name() {
		return 'playrxt_sehedule';
	}

	public function get_title() {
		return __( 'Tournament Schedule', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}

    public function get_keywords() {
		return [ 'touranament', 'schedule', 'game', 'playrex' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_match',
			[
				'label'		 	=> __( 'Tournament Schedule', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        /*  --------------- Repeater Section ---------------*/

        $t_schedule_repeater = new Repeater();

        
        /*  --------------- Left Section ---------------*/
        $t_schedule_repeater->add_control(
            'left_content',
            [
                'label' => __( 'Left Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );

        $t_schedule_repeater->add_control(
			'team_one_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $t_schedule_repeater->add_control(
			'team_one_name',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Rabbits Star', 'playrex' ),
                'label_block'   => true,
			]
        );
        $t_schedule_repeater->add_control(
			'team_one_name_url',
			[
				'label' 	=> __( 'Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '#', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Left Section ---------------*/

        /*  --------------- Middle Section ---------------*/
        $t_schedule_repeater->add_control(
            'middle_content',
            [
                'label' => __( 'Middle Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );
        $t_schedule_repeater->add_control(
			't_schedule_time',
			[
				'label' 	=> __( 'Tournament Schedule Time Duration', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '02:02', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Middle Section ---------------*/

        /*  --------------- Right Section ---------------*/
        $t_schedule_repeater->add_control(
            'right_content',
            [
                'label' => __( 'Right Content', 'playrex' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'separator' => 'before',
            ]
        );
        $t_schedule_repeater->add_control(
			'team_two_thumb',
			[
				'label' 		=> __( 'Team Image', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $t_schedule_repeater->add_control(
			'team_two_name',
			[
				'label' 	=> __( 'Team Name', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Wizard Wer', 'playrex' ),
                'label_block'   => true,
			]
        );
        $t_schedule_repeater->add_control(
			'team_two_name_url',
			[
				'label' 	=> __( 'Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '#', 'playrex' ),
                'label_block'   => true,
			]
        );
        /*  --------------- End Right Section ---------------*/

        /*  --------------- Bottom Section ---------------*/
        $t_schedule_repeater->add_control(
			't_schedule_date',
			[
				'label' 	=> __( 'Time And Date', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'November 25, 2022 4:00 PM', 'playrex' ),
                'label_block'   => true,
			]
        );
        
        $t_schedule_repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Watch Stream', 'playrex' ),
                'label_block'   => true,
			]
        );

        $t_schedule_repeater->add_control(
			'button_url',
			[
				'label' 	=> __( 'Button Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        /*  --------------- End Bottom Section ---------------*/

        $this->add_control(
			't_schedule_repeater',
			[
				'label' 		=> __( 'Tournament Schedule', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $t_schedule_repeater->get_controls(),
				'default' 		=> [
					[
						
                        'team_one_thumb' 	 => Utils::get_placeholder_image_src(),
                        'team_one_name'      => __( 'Rabbits Star', 'playrex' ),
                        'team_onw_name_url'      => __( '#', 'playrex' ),

                        't_schedule_time'         => __( '02:02', 'playrex' ),

                        't_schedule_date'         => __( 'November 25, 2022 4:00 PM', 'playrex' ),
                        'button_text'        => __( 'Watch Stream', 'playrex' ),
                        'button_url'         => __( '#', 'playrex' ),
                        
                        'team_two_thumb'  => Utils::get_placeholder_image_src(),
                        'team_two_name'    => __( 'Wizard Wer', 'playrex' ),
                        'team_two_name_url'      => __( '#', 'playrex' ),

					],
				],
				'title_field' 	=> '{{{ t_schedule_date }}}',
			]
		);
        /*  --------------- End Repeater Section ---------------*/
        $this->end_controls_section();
    

        /*  --------------- Date Style ---------------*/
        $this->start_controls_section(
			'heading_date',
			[
				'label'		 	=> __( 'Date', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'date_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-date' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'date_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-date',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Date Style ---------------*/


        /*  --------------- Team Thumnail Style ---------------*/
        $this->start_controls_section(
			'heading_team_logo',
			[
				'label'		 	=> __( 'Team Logo', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
			'team_logo_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Team Style ---------------*/

        /*  --------------- Team Style ---------------*/
        $this->start_controls_section(
			'heading_team_name',
			[
				'label'		 	=> __( 'Team Name', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'team_name_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'team_name_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .team-name',
			]
		);

        $this->add_responsive_control(
			'team_name_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .team-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
        $this->end_controls_section();
        /*  --------------- End Team Style ---------------*/

        /*  --------------- Time Style ---------------*/
        $this->start_controls_section(
			'heading_time',
			[
				'label'		 	=> __( 'Time', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'time_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-time' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'time_bg_color',
            [
                'label'     => __('Box Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-time' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'time_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-time',
			]
		);

        

        $this->add_responsive_control(
			'time_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();
        /*  --------------- End Time Style ---------------*/

        /*  ---------------  Arrow Style ---------------*/
        $this->start_controls_section(
			'arrow_style',
			[
				'label'		 	=> __( 'Arrow', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'arrow_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'arrow_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);
        $this->add_control(
            'arrow_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-arrow',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'arrow_Hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
        $this->add_control(
            'arrow_hover_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-arrow:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  ---------------  Arrow Style End ---------------*/

        /*  ---------------  Dots Style ---------------*/
        $this->start_controls_section(
			'dots_style',
			[
				'label'		 	=> __( 'Dots', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'dots_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'dots_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);
        $this->add_control(
            'dots_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-dots button' => 'Background color: {{VALUE}}',
                ],
            ]
        );

       

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-dots button',
            ]
		);
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'dots_Hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
        $this->add_control(
            'dots_bg_color_active',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-dots button, {{WRAPPER}} .match-custom .slick-dots .slick-active button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'dots_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-custom .slick-dots button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_hover_border',
                'label' => __('Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .match-custom .slick-dots button:hover',
            ]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*  ---------------  Dots Style End ---------------*/


        /*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'button_tab_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);

        $this->add_control(
            'button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .match-bottom .vs-btn',
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-bottom .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .match-bottom .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'button_tab_hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
		$this->add_control(
            'button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .match-bottom .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $t_schedule_repeater = $settings['t_schedule_repeater'];
        ?>

        <?php foreach($t_schedule_repeater as $t_schedule): ?>
            <div class="match-style1">
                <div class="match-top">
                    <div class="match-team">

                        <?php if(!empty($t_schedule['team_one_thumb']['url'])): ?>
                            <div class="team-logo">
                                <a href="<?php echo esc_url($t_schedule['team_onw_name_url']) ?>">
                                     <?php
                                        echo playrex_img_tag([
                                            'url' => $t_schedule['team_one_thumb']['url'],
                                        ]);
                                     ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($t_schedule['team_one_name'])): ?>
                            <h3 class="h6 team-name">
                                <a href="<?php echo esc_url($t_schedule['team_onw_name_url']) ?>" class="text-inherit">
                                    <?php echo esc_html($t_schedule['team_one_name']); ?>
                                </a>
                            </h3>
                        <?php endif; ?>
                    </div>

                    <?php if(!empty($t_schedule['t_schedule_time'])): ?>
                        <div class="match-time">
                            <?php echo esc_html($t_schedule['t_schedule_time']); ?>
                        </div>
                    <?php endif; ?>

                    <div class="match-team">
                        <?php if(!empty($t_schedule['team_two_thumb']['url'])): ?>
                            <div class="team-logo">
                                <a href="<?php echo esc_url($t_schedule['team_two_name_url']) ?>">
                                     <?php
                                        echo playrex_img_tag([
                                            'url' => $t_schedule['team_two_thumb']['url'],
                                        ]);
                                     ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($t_schedule['team_two_name'])): ?>
                            <h3 class="h6 team-name">
                                <a href="<?php echo esc_url($t_schedule['team_two_name_url']) ?>" class="text-inherit">
                                    <?php echo esc_html($t_schedule['team_two_name']); ?>
                                </a>
                            </h3>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="match-bottom">
                    <?php if(!empty($t_schedule['t_schedule_date'])): ?>
                        <p class="match-date">
                            <?php echo esc_html($t_schedule['t_schedule_date']); ?>
                        </p>
                    <?php endif; ?>

                    <?php if(!empty($t_schedule['button_text'])): ?>
                        <a href="<?php echo esc_url($t_schedule['button_url']) ?>" class="match-btn">
                            <i class="fab fa-twitch"></i><?php echo esc_html($t_schedule['button_text']); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
        <?php
	}
}