<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Featurematch Box Widget .
 *
 */
class Playrex_Upcoming_Tournament extends Widget_Base {

	public function get_name() {
		return 'playrexupcoming_t';
	}

	public function get_title() {
		return __( 'Upcoming Tournament', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-icon-box playrex';
    }

	public function get_categories() {
		return [ 'playrex' ];
	}


    public function get_keywords() {
		return [ 'upcoming','playrex', 'match' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_tournament',
			[
				'label' 	=> __( 'Upcoming Tournament', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );


		$this->add_control(
			'active_slider',
			[
				'label' 		=> __( 'Active Slider', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		/*  --------------- Repeater Section ---------------*/

        $up_tournament_repeater = new Repeater();

        /*  --------------- Feature Match Section ---------------*/

		$up_tournament_repeater->add_control(
			'upt_background',
			[
				'label' 		=> __( 'Thumbanil', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$up_tournament_repeater->add_control(
			'upt_badges',
			[
				'label' 		=> __( 'Badge', 'playrex' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$up_tournament_repeater->add_control(
			'upt_day',
			[
				'label' 	=> __( 'Day', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_time',
			[
				'label' 	=> __( 'Time', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );
        
		$up_tournament_repeater->add_control(
			'upt_price',
			[
				'label' 	=> __( 'Price', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_icon',
			[
				'label' 	=> __( 'Price Icon', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_label',
			[
				'label' 	=> __( 'Label', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_title',
			[
				'label' 	=> __( 'Title', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_title_url',
			[
				'label' 	=> __( 'Title Url', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_location',
			[
				'label' 	=> __( 'Location', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$up_tournament_repeater->add_control(
			'upt_location_icon',
			[
				'label' 	=> __( 'Location Icon', 'playrex' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block'   => true,
			]
        );

		$this->add_control(
			'up_tournament_repeaters',
			[
				'label' 		=> __( 'Match', 'playrex' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $up_tournament_repeater->get_controls(),
				'default' 		=> [
					[
						'upt_day'           => __( 'AUG12SU', 'playrex' ),
						'upt_time'          => __( 'SUN 12:00 PKT', 'playrex' ),
						'upt_price'         => __( '$150.00', 'playrex' ),
                        'upt_background'    => Utils::get_placeholder_image_src(),
                        'upt_badges' 	    => Utils::get_placeholder_image_src(),
                        'upt_icon'          => __( 'fas fa-trophy-alt', 'playrex' ),
                        'upt_label'         => __( '1v1, Single Elimination', 'playrex' ),
                        'upt_title'         => __( 'Global Esports Games 2023', 'playrex' ),
                        'upt_title_url'     => __( '#', 'playrex' ),
                        'upt_location'      => __( '#', 'playrex' ),
                        'upt_location_icon' => __( 'fas fa-map-marker-alt', 'playrex' ),
                    ],
				],
				'title_field' 	=> '{{{ upt_title }}}',
			]
		);
        
        $this->end_controls_section();
        /*  --------------- End  Repitar ---------------*/


        /*  --------------- Slider Settings ---------------*/
    

        $this->start_controls_section(
			'up_slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

		$this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'playrex' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 2,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
	

		$this->add_control(
			'up_slidr_dots',
			[
				'label' 		=> __( 'Dots?', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		$this->add_control(
			'up_slider_autoplay',
			[
				'label' 		=> __( 'AutoPlay', 'playrex' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'playrex' ),
				'label_off' 	=> __( 'No', 'playrex' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Slider Settings ---------------*/




		/*  --------------- Title Style ---------------*/
        $this->start_controls_section(
			'heading_title',
			[
				'label'		 	=> __( 'Title', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );


        $this->add_control(
            'shape_color',
            [   
                'label'     => __('Shape Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-style4 .tournament-shape1, {{WRAPPER}} .tournament-style4' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [   
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [   
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-name .text-inherit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-name',
			]
		);
        $this->end_controls_section();
        /*  --------------- End Title Style ---------------*/

		/*  --------------- Dis Style ---------------*/
		$this->start_controls_section(
			'dis_title',
			[
				'label'		 	=> __( 'Discription', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'tournament_dis_color',
            [   
                'label'     => __('Info label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-text' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'dis_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-text',
			]
		);

		$this->end_controls_section();
		/*  --------------- Dis Style ---------------*/

		/*  --------------- UpcomingTournament Label ---------------*/
        $this->start_controls_section(
			'tournament_label_title',
			[
				'label'		 	=> __( 'UpcomingTournament Label', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
            'tournament_label_color',
            [   
                'label'     => __('Info label Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-info-label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tournament_info_color',
            [   
                'label'     => __('Info Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .tournament-info-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_label_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-info-label',
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'tournament_info_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .tournament-info-text',
			]
		);
        $this->end_controls_section();
        /*  --------------- UpcomingTournament Label ---------------*/


		

		/*  --------------- Button Style ---------------*/
		$this->start_controls_section(
			'fm_button_style',
			[
				'label'		 	=> __( 'Button', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->start_controls_tabs( 'fm_button_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'fm_button_tab_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);

        $this->add_control(
            'fm_button_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'fm_button_typography',
				'label' 		=> __( 'Typography', 'playrex' ),
				'selector' 		=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_responsive_control(
			'fm_button_margin',
			[
				'label' 		=> __( 'Margin', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'fm_button_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'fm_button_tab_hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
		$this->add_control(
            'fm_button_color_hover',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'fm_button_bg_color_hover',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vs-btn:after, {{WRAPPER}} .vs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        /*  --------------- End Button Style ---------------*/

		/*  ---------------  nav Style ---------------*/
        $this->start_controls_section(
			'fm_nav_style',
			[
				'label'		 	=> __( 'Arrow', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [ 'active_slider' => 'yes' ]
			]
        );

        $this->start_controls_tabs( 'fm_nav_tabs' );
		/*  ---- Normal Tab -----*/
		$this->start_controls_tab( 
			'fm_nav_normal', 
			[ 
				'label' => esc_html__( 'Normal', 'playrex' ), 
			], 
		);

        $this->add_control(
            'fm_nav_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_nav_bg_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

		/*  ---- Hover Tab -----*/
		$this->start_controls_tab( 
			'fm_nav_Hover', 
			[ 
				'label' => esc_html__( 'Hover', 'playrex' ), 
			], 
		);
		$this->add_control(
            'fm_nav_hover_color',
            [
                'label'     => __('Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'fm_nav_bg_hover_color',
            [
                'label'     => __('Background Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tournament-nav-slide .slick-arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();



    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		


		$up_tournament_repeaters = $settings['up_tournament_repeaters'];

        // var_dump($up_tournament_repeaters);

        // data-slide-show="2" data-md-slide-show="2" data-dots="true"
        // vs-carousel

        if( 'yes' == $settings['active_slider']){
            $this->add_render_attribute( 'wrapper', 'class', ['row up_tournament_slider'] );
            if($settings['up_slider_autoplay'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-autoplay',  'false' );
            }

            if($settings['up_slidr_dots'] == 'yes'){
                $this->add_render_attribute( 'wrapper', 'data-slick-dots',  'true' );
            }else{
                $this->add_render_attribute( 'wrapper', 'data-slick-dots',  'false' );
            }
            $this->add_render_attribute( 'wrapper', 'data-slide-to-show',  $settings['per_coulmn']);
            
        }else{
			$this->add_render_attribute( 'wrapper', 'class', ['row'] );
        }

        ?>



    <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
        <?php foreach($up_tournament_repeaters as $upt): ?>
            <div class="col-xl-6">
                <div class="tournament-style2">
                    <div class="tournament-img">
                        <?php if(!empty($upt['upt_badges']['url'])): ?>
                            <div class="tournament-badges">
                                <?php
                                    echo playrex_img_tag([
                                        'url' => $upt['upt_badges']['url'],
                                    ]);
                                ?>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($upt['upt_background']['url'])): ?>
                            <?php
                                echo playrex_img_tag([
                                    'url' => $upt['upt_background']['url'],
                                ]);
                            ?>
                        <?php endif; ?>
                        <div class="tournament-date">
                            <?php if(!empty($upt['upt_day'] ) ): ?>
                                <span class="day">
                                    <?php echo esc_html($upt['upt_day']); ?>
                                </span>
                            <?php endif; ?>

                            <?php if(!empty($upt['upt_time'] ) ): ?>
                                <div class="time"><?php echo esc_html($upt['upt_time']); ?></div>
                            <?php endif; ?>

                        </div>
                    </div>
                    <div class="tournament-content">
                        <?php if(!empty($upt['upt_price'] ) ): ?>
                            <div class="tournament-price">
                                <i class="<?php echo esc_attr($upt['upt_icon'] ); ?>"></i><?php echo esc_html($upt['upt_price']); ?>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($upt['upt_label'] ) ): ?>
                            <p class="tournament-label">
                                <?php echo esc_html($upt['upt_label'] ); ?>
                            </p>
                        <?php endif; ?>
                        <?php if(!empty($upt['upt_title']) ):  ?>
                            <h3 class="tournament-title">
                                <a href="<?php echo esc_url($upt['upt_title_url'] ); ?>" class="text-inherit">
                                    <?php echo esc_html($upt['upt_title'] ); ?>
                                </a>
                            </h3>
                        <?php endif; ?>
                        <?php if(!empty($upt['upt_location'])): ?>
                            <div class="tournament-bottom">
                                <div class="tournament-location">
                                    <i class="<?php echo esc_attr($upt['upt_location_icon']); ?>"></i>
                                    <?php echo wp_kses_post($upt['upt_location']); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>   
            </div>   
            <?php endforeach; ?>
        </div>
    <?php 

		
        
	}
}

?>
