<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Minicart Box Widget .
 *
 */
class Playrex_Minicart extends Widget_Base {

	public function get_name() {
		return 'playrexpr minicart';
	}

	public function get_title() {
		return __( 'Minicart', 'playrex' );
	}

	public function get_icon() {
		return 'eicon-cart playrex';
    }

	public function get_categories() {
		return [ 'playrex_header_elements' ];
	}


    public function get_keywords() {
		return [ 'minicart', 'minicart', 'playrex', 'woocommerce' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'playrex_minicart',
			[
				'label' 	=> __( 'Minicart', 'playrex' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'cart_url',
			[
				'label' 	=> __( 'Cart Url', 'playrex' ),
                'type' 		=> Controls_Manager::URL,
                'label_block'   => true,
			]
        );

		
        $this->end_controls_section();

		$this->start_controls_section(
			'minicar_style',
			[
				'label'		 	=> __( 'Mini Cart', 'playrex' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_responsive_control(
			'cart_size',
			[
				'label' => esc_html__( 'Font Size', 'playrex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .cart-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'cart_color',
            [
                'label'     => __('Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cart-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'cart_color_hover',
            [
                'label'     => __(' Hover Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'cart_bg_color',
            [
                'label'     => __('Hover Bg Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'cart_color_bg_hover',
            [
                'label'     => __(' Hover Bg Color', 'playrex'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cart-icon:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'cart_border',
                'label' => __('Icon Border', 'playrex'),
                'selector' => '{{WRAPPER}}  .cart-icon',
            ]
		);
		$this->add_responsive_control(
			'cart_padding',
			[
				'label' 		=> __( 'Padding', 'playrex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .cart-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();
		
        
        /*  --------------- End Minicart Style ---------------*/

    }
	protected function render() {

        $settings = $this->get_settings_for_display();

		$target   = $settings['cart_url']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['cart_url']['nofollow'] ? ' rel="nofollow"' : '';
		$url      = $settings['cart_url']['url'];

		$this->add_render_attribute( 'wrapper', 'href', [$url] );
        $this->add_render_attribute( 'wrapper', 'class', ['cart-icon'] );
		
		if( ! empty( $target ) || ! empty( $nofollow ) ){
	        $this->add_render_attribute( 'wrapper', 'attr', [ $target, $nofollow] );
		}
       
        ?>
            <?php if( class_exists( 'WooCommerce' )  ): ?>
                <a <?php echo  $this->get_render_attribute_string('wrapper') ?> >
                    <i class="far fa-shopping-bag"></i></a>
            <?php endif; ?>
        <?php

        
	}
}