<?php
    /**
     * Class For Builder
     */
    class PlayrexBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'playrex_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'playrex-core',PLAYREX_PLUGDIRURI.'assets/js/playrex-core.js',array( 'jquery' ),'1.0',true );
		}


        public function playrex_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'playrex_header_option',
                [
                    'label'     => __( 'Header Option', 'playrex' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );

            $page->add_control(
                'playrex_header_style',
                [
                    'label'     => __( 'Header Option', 'playrex' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'playrex' ),
    					'header_builder'       => __( 'Header Builder', 'playrex' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'playrex_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'playrex' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->playrex_header_choose_option(),
                    'condition' => [ 'playrex_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'playrex_footer_option',
                [
                    'label'     => __( 'Footer Option', 'playrex' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'playrex_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'playrex' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'playrex' ),
    				'label_off'     => __( 'No', 'playrex' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'playrex_footer_style',
                [
                    'label'     => __( 'Footer Style', 'playrex' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'playrex' ),
    					'footer_builder'       => __( 'Footer Builder', 'playrex' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'playrex_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'playrex_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'playrex' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->playrex_footer_choose_option(),
                    'condition' => [ 'playrex_footer_style' => 'footer_builder','playrex_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Playrex Builder', 'playrex' ),
            	esc_html__( 'Playrex Builder', 'playrex' ),
				'manage_options',
				'playrex',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('playrex', esc_html__('Footer Builder', 'playrex'), esc_html__('Footer Builder', 'playrex'), 'manage_options', 'edit.php?post_type=playrex_footer');
			add_submenu_page('playrex', esc_html__('Header Builder', 'playrex'), esc_html__('Header Builder', 'playrex'), 'manage_options', 'edit.php?post_type=playrex_header');
			add_submenu_page('playrex', esc_html__('Tab Builder', 'playrex'), esc_html__('Tab Builder', 'playrex'), 'manage_options', 'edit.php?post_type=playrex_tab_build');
			add_submenu_page('playrex', esc_html__('Menu Builder', 'playrex'), esc_html__('Menu Builder', 'playrex'), 'manage_options', 'edit.php?post_type=playrex_menu_build');
			add_submenu_page('playrex', esc_html__('Offcanvas Builder', 'playrex'), esc_html__('Offcanvas Builder', 'playrex'), 'manage_options', 'edit.php?post_type=playrex_off_build');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','playrex' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'playrex' ),
				'singular_name'      => __( 'Footer', 'playrex' ),
				'menu_name'          => __( 'Playrex Footer Builder', 'playrex' ),
				'name_admin_bar'     => __( 'Footer', 'playrex' ),
				'add_new'            => __( 'Add New', 'playrex' ),
				'add_new_item'       => __( 'Add New Footer', 'playrex' ),
				'new_item'           => __( 'New Footer', 'playrex' ),
				'edit_item'          => __( 'Edit Footer', 'playrex' ),
				'view_item'          => __( 'View Footer', 'playrex' ),
				'all_items'          => __( 'All Footer', 'playrex' ),
				'search_items'       => __( 'Search Footer', 'playrex' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'playrex' ),
				'not_found'          => __( 'No Footer found.', 'playrex' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'playrex' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'playrex_footer', $args );

			$labels = array(
				'name'               => __( 'Header', 'playrex' ),
				'singular_name'      => __( 'Header', 'playrex' ),
				'menu_name'          => __( 'Playrex Header Builder', 'playrex' ),
				'name_admin_bar'     => __( 'Header', 'playrex' ),
				'add_new'            => __( 'Add New', 'playrex' ),
				'add_new_item'       => __( 'Add New Header', 'playrex' ),
				'new_item'           => __( 'New Header', 'playrex' ),
				'edit_item'          => __( 'Edit Header', 'playrex' ),
				'view_item'          => __( 'View Header', 'playrex' ),
				'all_items'          => __( 'All Header', 'playrex' ),
				'search_items'       => __( 'Search Header', 'playrex' ),
				'parent_item_colon'  => __( 'Parent Header:', 'playrex' ),
				'not_found'          => __( 'No Header found.', 'playrex' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'playrex' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'playrex_header', $args );

            $labels = array(
				'name'               => __( 'Tab Builder', 'playrex' ),
				'singular_name'      => __( 'Tab Builder', 'playrex' ),
				'menu_name'          => __( 'Foodelio Tab Builder', 'playrex' ),
				'name_admin_bar'     => __( 'Tab Builder', 'playrex' ),
				'add_new'            => __( 'Add New', 'playrex' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'playrex' ),
				'new_item'           => __( 'New Tab Builder', 'playrex' ),
				'edit_item'          => __( 'Edit Tab Builder', 'playrex' ),
				'view_item'          => __( 'View Tab Builder', 'playrex' ),
				'all_items'          => __( 'All Tab Builder', 'playrex' ),
				'search_items'       => __( 'Search Tab Builder', 'playrex' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'playrex' ),
				'not_found'          => __( 'No Tab Builder found.', 'playrex' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'playrex' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'playrex_tab_build', $args );


			// menu
            $labels = array(
				'name'               => __( 'Menu Builder', 'playrex' ),
				'singular_name'      => __( 'Menu Builder', 'playrex' ),
				'menu_name'          => __( 'Foodelio Menu Builder', 'playrex' ),
				'name_admin_bar'     => __( 'Menu Builder', 'playrex' ),
				'add_new'            => __( 'Add New', 'playrex' ),
				'add_new_item'       => __( 'Add New Menu Builder', 'playrex' ),
				'new_item'           => __( 'New Menu Builder', 'playrex' ),
				'edit_item'          => __( 'Edit Menu Builder', 'playrex' ),
				'view_item'          => __( 'View Menu Builder', 'playrex' ),
				'all_items'          => __( 'All Menu Builder', 'playrex' ),
				'search_items'       => __( 'Search Menu Builder', 'playrex' ),
				'parent_item_colon'  => __( 'Parent Menu Builder:', 'playrex' ),
				'not_found'          => __( 'No Menu Builder found.', 'playrex' ),
				'not_found_in_trash' => __( 'No Menu Builder found in Trash.', 'playrex' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'playrex_menu_build', $args );


			
			// menu
            $labels = array(
				'name'               => __( 'Offcanvas Builder', 'playrex' ),
				'singular_name'      => __( 'Offcanvas Builder', 'playrex' ),
				'menu_name'          => __( 'Foodelio Offcanvas Builder', 'playrex' ),
				'name_admin_bar'     => __( 'Offcanvas Builder', 'playrex' ),
				'add_new'            => __( 'Add New', 'playrex' ),
				'add_new_item'       => __( 'Add New Offcanvas Builder', 'playrex' ),
				'new_item'           => __( 'New Offcanvas Builder', 'playrex' ),
				'edit_item'          => __( 'Edit Offcanvas Builder', 'playrex' ),
				'view_item'          => __( 'View Offcanvas Builder', 'playrex' ),
				'all_items'          => __( 'All Offcanvas Builder', 'playrex' ),
				'search_items'       => __( 'Search Offcanvas Builder', 'playrex' ),
				'parent_item_colon'  => __( 'Parent Offcanvas Builder:', 'playrex' ),
				'not_found'          => __( 'No Offcanvas Builder found.', 'playrex' ),
				'not_found_in_trash' => __( 'No Offcanvas Builder found in Trash.', 'playrex' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'playrex_off_build', $args );

		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'playrex_footer' == $post->post_type || 'playrex_header' == $post->post_type || 'playrex_tab_build' == $post->post_type || 'playrex_off_build' == $post->post_type || 'playrex_menu_build' == $post->post_type) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function playrex_footer_choose_option(){

			$playrex_post_query = new WP_Query( array(
				'post_type'			=> 'playrex_footer',
				'posts_per_page'	=> -1,
			) );

			$playrex_builder_post_title = array();
			$playrex_builder_post_title[''] = __( 'Select a Footer', 'playrex' );

			while( $playrex_post_query->have_posts() ) {
				$playrex_post_query->the_post();
				$playrex_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $playrex_builder_post_title;

		}

		public function playrex_header_choose_option(){

			$playrex_post_query = new WP_Query( array(
				'post_type'			=> 'playrex_header',
				'posts_per_page'	=> -1,
			) );

			$playrex_builder_post_title = array();
			$playrex_builder_post_title[''] = __( 'Select a Header', 'playrex' );

			while( $playrex_post_query->have_posts() ) {
				$playrex_post_query->the_post();
				$playrex_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $playrex_builder_post_title;

        }

    }

    $builder_execute = new PlayrexBuilder();