<?php
/**
 * @Packge     : Playrex
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function playrex_core_essential_scripts( ) {
    wp_enqueue_script('playrex-ajax',PLAYREX_PLUGDIRURI.'assets/js/playrex.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'playrex-ajax',
    'playrexajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'playrex-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','playrex_core_essential_scripts');


// playrex Section subscribe ajax callback function
add_action( 'wp_ajax_playrex_subscribe_ajax', 'playrex_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_playrex_subscribe_ajax', 'playrex_subscribe_ajax' );

function playrex_subscribe_ajax( ){
  $apiKey = playrex_opt('playrex_subscribe_apikey');
  $listid = playrex_opt('playrex_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'playrex-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'playrex').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'playrex').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'playrex').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'playrex').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'playrex').'</div>';
        }
   }

   wp_die();

}