<?php
/**
 * Plugin Name: Playrex Core
 * Description: This is a helper plugin of playrex theme
 * Version:     1.0.1
 * Author:      Vecurosoft
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: playrex
 */
 // Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit();
}

// Define Constant
define( 'PLAYREX_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'PLAYREX_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'PLAYREX_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );
define( 'PLAYREX_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );
define( 'PLAYREX_PLUGDIRURI', plugin_dir_url( __FILE__ ) );
define( 'PLAYREX_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );
define( 'PLAYREX_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'playrex-template/' );

// load textdomain
load_plugin_textdomain( 'playrex', false, basename( dirname( __FILE__ ) ) . '/languages' );

//include file.
require_once PLAYREX_PLUGIN_INC_PATH .'playrexcore-functions.php';
require_once PLAYREX_PLUGIN_INC_PATH . 'MCAPI.class.php';
require_once PLAYREX_PLUGIN_INC_PATH .'playrexajax.php';
require_once PLAYREX_PLUGIN_INC_PATH .'builder/builder.php';

require_once PLAYREX_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';

//Widget
require_once PLAYREX_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
require_once PLAYREX_PLUGIN_WIDGET_PATH . 'social-widget.php';
require_once PLAYREX_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
require_once PLAYREX_PLUGIN_WIDGET_PATH . 'newsletter-widget.php';
// require_once PLAYREX_PLUGIN_WIDGET_PATH . 'footer-map.php';

//addons
require_once PLAYREX_ADDONS . 'addons.php';